/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.utils.math;

import maninthehouse.epicfight.utils.math.Vec3f;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class MathUtils {
    public static VisibleMatrix4f getModelMatrixIntegrated(float prevPosX, float posX, float prevPosY, float posY, float prevPosZ, float posZ, float prevPitch, float pitch, float prevYaw, float yaw, float partialTick, float scaleX, float scaleY, float scaleZ) {
        VisibleMatrix4f modelMatrix = new VisibleMatrix4f().setIdentity();
        Vec3f entityPosition = new Vec3f(-(prevPosX + (posX - prevPosX) * partialTick), prevPosY + (posY - prevPosY) * partialTick, -(prevPosZ + (posZ - prevPosZ) * partialTick));
        VisibleMatrix4f.translate(entityPosition, modelMatrix, modelMatrix);
        float pitchDegree = MathUtils.interpolateRotation(prevPitch, pitch, partialTick);
        float yawDegree = MathUtils.interpolateRotation(prevYaw, yaw, partialTick);
        VisibleMatrix4f.rotate((float)(-Math.toRadians(yawDegree)), new Vec3f(0.0f, 1.0f, 0.0f), modelMatrix, modelMatrix);
        VisibleMatrix4f.rotate((float)(-Math.toRadians(pitchDegree)), new Vec3f(1.0f, 0.0f, 0.0f), modelMatrix, modelMatrix);
        VisibleMatrix4f.scale(new Vec3f(scaleX, scaleY, scaleZ), modelMatrix, modelMatrix);
        return modelMatrix;
    }

    public static Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76134_b((float)f1);
        float f3 = MathHelper.func_76126_a((float)f1);
        float f4 = MathHelper.func_76134_b((float)f);
        float f5 = MathHelper.func_76126_a((float)f);
        return new Vec3d((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static float interpolateRotation(float par1, float par2, float par3) {
        float f = 0.0f;
        for (f = par2 - par1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return par1 + par3 * f;
    }

    public static float getInterpolatedRotation(float par1, float par2, float par3) {
        float f = 0.0f;
        for (f = par2 - par1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return par3 * f;
    }

    public static double getAngleBetween(Entity e1, Entity e2) {
        Vec3d a = e1.func_70040_Z();
        Vec3d b = new Vec3d(e2.field_70165_t - e1.field_70165_t, e2.field_70163_u - e1.field_70163_u, e2.field_70161_v - e1.field_70161_v).func_72432_b();
        double cosTheta = a.field_72450_a * b.field_72450_a + a.field_72448_b * b.field_72448_b + a.field_72449_c * b.field_72449_c;
        return Math.acos(cosTheta);
    }

    public static double lerp(double pct, double start, double end) {
        return start + pct * (end - start);
    }
}

