/*
 * Decompiled with CFR 0.152.
 */
package com.driga.jmodelloader.obj.armor.manager;

import com.driga.jmodelloader.JModelLoader;
import com.driga.jmodelloader.model.ModelManager;
import com.driga.jmodelloader.obj.armor.ArmorRegistry;
import com.driga.jmodelloader.obj.armor.model.ModelArmor;
import com.driga.jmodelloader.obj.loader.AdvancedModelLoaderRegistry;
import com.driga.jmodelloader.obj.loader.IModelCustom;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.util.ResourceLocation;

public class CustomArmorManagerClient {
    public static void registerModels() {
        List<String> models = ModelManager.getAllArmorModels();
        for (String model : models) {
            CustomArmorManagerClient.registerAllModels(model);
        }
    }

    private static void registerAllModels(String model) {
        ArmorRegistry.Instance.registerModel(model + "_head", CustomArmorManagerClient.getHead(model));
        ArmorRegistry.Instance.registerModel(model + "_chest", CustomArmorManagerClient.getBody(model));
        ArmorRegistry.Instance.registerModel(model + "_legs", CustomArmorManagerClient.getLegs(model));
        ArmorRegistry.Instance.registerModel(model + "_boots", CustomArmorManagerClient.getBoots(model));
    }

    private static String[] getResourceListing(Class clazz, String path) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String entry;
                String name = entries.nextElement().getName();
                if (!name.startsWith(path) || (entry = name.replace(path + "/", "")).equals("")) continue;
                result.add(entry);
            }
            return result.toArray(new String[result.size()]);
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }

    private static ModelArmor getHead(String model) {
        ModelArmor modelArmor = new ModelArmor(new ResourceLocation("jmodelloader", "textures/65/" + model + ".png"));
        String[] folder = null;
        try {
            folder = CustomArmorManagerClient.getResourceListing(JModelLoader.class, "assets/jmodelloader/models/33/" + model);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String fileEntry : folder) {
            String part = fileEntry.replaceAll(".obj", "");
            if (!part.equals("head")) continue;
            IModelCustom head = AdvancedModelLoaderRegistry.ARMOR.getModel(new ResourceLocation("jmodelloader", "models/33/" + model + "/head.obj"));
            modelArmor.head(head);
        }
        return modelArmor;
    }

    private static ModelArmor getBody(String model) {
        ModelArmor modelArmor = new ModelArmor(new ResourceLocation("jmodelloader", "textures/65/" + model + ".png"));
        String[] folder = null;
        try {
            folder = CustomArmorManagerClient.getResourceListing(JModelLoader.class, "assets/jmodelloader/models/33/" + model);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IModelCustom body = null;
        IModelCustom rightArm = null;
        IModelCustom leftArm = null;
        for (String fileEntry : folder) {
            String part = fileEntry.replaceAll(".obj", "");
            if (!part.equals("body") && !part.equals("rightarm") && !part.equals("leftarm")) continue;
            if (part.equals("body")) {
                body = AdvancedModelLoaderRegistry.ARMOR.getModel(new ResourceLocation("jmodelloader", "models/33/" + model + "/body.obj"));
            }
            if (part.equals("rightarm")) {
                rightArm = AdvancedModelLoaderRegistry.ARMOR.getModel(new ResourceLocation("jmodelloader", "models/33/" + model + "/rightarm.obj"));
            }
            if (!part.equals("leftarm")) continue;
            leftArm = AdvancedModelLoaderRegistry.ARMOR.getModel(new ResourceLocation("jmodelloader", "models/33/" + model + "/leftarm.obj"));
        }
        modelArmor.body(body, rightArm, leftArm);
        return modelArmor;
    }

    private static ModelArmor getLegs(String model) {
        ModelArmor modelArmor = new ModelArmor(new ResourceLocation("jmodelloader", "textures/65/" + model + ".png"));
        String[] folder = null;
        try {
            folder = CustomArmorManagerClient.getResourceListing(JModelLoader.class, "assets/jmodelloader/models/33/" + model);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IModelCustom rightLeg = null;
        IModelCustom leftLeg = null;
        for (String fileEntry : folder) {
            String part = fileEntry.replaceAll(".obj", "");
            if (!part.equals("rightleg") && !part.equals("leftleg")) continue;
            if (part.equals("rightleg")) {
                rightLeg = AdvancedModelLoaderRegistry.ARMOR.getModel(new ResourceLocation("jmodelloader", "models/33/" + model + "/rightleg.obj"));
            }
            if (!part.equals("leftleg")) continue;
            leftLeg = AdvancedModelLoaderRegistry.ARMOR.getModel(new ResourceLocation("jmodelloader", "models/33/" + model + "/leftleg.obj"));
        }
        modelArmor.leg(rightLeg, leftLeg);
        return modelArmor;
    }

    private static ModelArmor getBoots(String model) {
        ModelArmor modelArmor = new ModelArmor(new ResourceLocation("jmodelloader", "textures/65/" + model + ".png"));
        String[] folder = null;
        try {
            folder = CustomArmorManagerClient.getResourceListing(JModelLoader.class, "assets/jmodelloader/models/33/" + model);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IModelCustom rightBoot = null;
        IModelCustom leftBoot = null;
        for (String fileEntry : folder) {
            String part = fileEntry.replaceAll(".obj", "");
            if (!part.equals("rightboot") && !part.equals("leftboot")) continue;
            if (part.equals("rightboot")) {
                rightBoot = AdvancedModelLoaderRegistry.ARMOR.getModel(new ResourceLocation("jmodelloader", "models/33/" + model + "/rightboot.obj"));
            }
            if (!part.equals("leftboot")) continue;
            leftBoot = AdvancedModelLoaderRegistry.ARMOR.getModel(new ResourceLocation("jmodelloader", "models/33/" + model + "/leftboot.obj"));
        }
        modelArmor.boot(rightBoot, leftBoot);
        return modelArmor;
    }
}

