/*
 * Decompiled with CFR 0.152.
 */
package com.driga.jmodelloader.obj.loader;

import com.driga.jmodelloader.obj.loader.AdvancedModelLoader;
import com.driga.jmodelloader.obj.loader.IModelCustom;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum AdvancedModelLoaderRegistry {
    ARMOR("models/item");

    private final Map<String, IModelCustom> models = new HashMap<String, IModelCustom>();
    private final String path;

    private AdvancedModelLoaderRegistry(String path) {
        this.path = path;
    }

    public IModelCustom getModel(ResourceLocation location) {
        if (!this.models.containsKey(location.func_110623_a())) {
            IModelCustom model = AdvancedModelLoader.loadModel(location);
            if (model == null) {
                FMLLog.log.error(String.format("Could not load model %s, skipping", location.toString()));
                return null;
            }
            this.models.put(location.func_110623_a(), model);
            return model;
        }
        return this.models.get(location.func_110623_a());
    }

    public IModelCustom getModel(String modid, String name) {
        return this.getModel(this.getResource(modid, name));
    }

    protected ResourceLocation getResource(String modid, String name) {
        return new ResourceLocation(modid, String.format(this.path + "/%s", name));
    }
}

