/*
 * Decompiled with CFR 0.152.
 */
package com.ramonrpa.customhud;

import com.ramonrpa.customhud.Hud;
import com.ramonrpa.customhud.Main;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PlayerInfoMessage
implements IMessage {
    private float health;
    private float maxHeath;
    private float mana;
    private float maxMana;
    private int lvl;

    public PlayerInfoMessage() {
    }

    public PlayerInfoMessage(float health, float maxHeath, float mana, float maxMana, int lvl) {
        this.health = health;
        this.maxHeath = maxHeath;
        this.mana = mana;
        this.maxMana = maxMana;
        this.lvl = lvl;
    }

    public void fromBytes(ByteBuf buf) {
        this.health = buf.readFloat();
        this.maxHeath = buf.readFloat();
        this.mana = buf.readFloat();
        this.maxMana = buf.readFloat();
        this.lvl = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.health);
        buf.writeFloat(this.maxHeath);
        buf.writeFloat(this.mana);
        buf.writeFloat(this.maxMana);
        buf.writeInt(this.lvl);
    }

    public static class PlayerInfoHandler
    implements IMessageHandler<PlayerInfoMessage, IMessage> {
        public IMessage onMessage(PlayerInfoMessage message, MessageContext ctx) {
            Hud.PlayerInfo info = Main.hud.info;
            info.setHealth(message.health);
            info.setMaxHeath(message.maxHeath);
            info.setMana(message.mana);
            info.setMaxMana(message.maxMana);
            info.setLvl(message.lvl);
            return null;
        }
    }
}

