/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.ClientProxy;
import com.lycanitesmobs.client.model.ModelEquipmentPart;
import com.lycanitesmobs.client.model.ModelItemBase;
import com.lycanitesmobs.client.model.ModelObjOld;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AssetManager {
    public static Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();
    public static Map<String, ResourceLocation[]> textureGroups = new HashMap<String, ResourceLocation[]>();
    public static Map<String, SoundEvent> sounds = new HashMap<String, SoundEvent>();
    public static Map<String, ModelBase> models = new HashMap<String, ModelBase>();
    public static Map<ProjectileInfo, ModelBase> projectileModels = new HashMap<ProjectileInfo, ModelBase>();
    public static Map<String, IModel> objModels = new HashMap<String, IModel>();
    public static Map<String, ModelItemBase> itemModels = new HashMap<String, ModelItemBase>();

    public static void addTexture(String name, ModInfo modInfo, String path) {
        name = name.toLowerCase();
        textures.put(name, new ResourceLocation(modInfo.modid, path));
    }

    public static void addTextureGroup(String name, ModInfo modInfo, String[] paths) {
        name = name.toLowerCase();
        ResourceLocation[] textureGroup = new ResourceLocation[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            textureGroup[i] = new ResourceLocation(modInfo.modid, paths[i]);
        }
        textureGroups.put(name, textureGroup);
    }

    public static void addSound(String name, ModInfo modInfo, String path) {
        name = name.toLowerCase();
        ResourceLocation resourceLocation = new ResourceLocation(modInfo.modid, path);
        SoundEvent soundEvent = new SoundEvent(resourceLocation);
        soundEvent.setRegistryName(resourceLocation);
        sounds.put(name, soundEvent);
        GameRegistry.findRegistry(SoundEvent.class).register((IForgeRegistryEntry)soundEvent);
    }

    public static void addModel(String name, ModelBase model) {
        name = name.toLowerCase();
        models.put(name, model);
    }

    public static void addObjModel(String name, ModInfo modInfo, String path) {
        name = name.toLowerCase();
        objModels.put(name, ModelObjOld.loadModel(new ResourceLocation(modInfo.modid, "models/" + path + ".obj")));
    }

    public static void addItemModel(String name, ModelItemBase model) {
        name = name.toLowerCase();
        itemModels.put(name, model);
    }

    public static ResourceLocation getTexture(String name) {
        if (!textures.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return textures.get(name);
    }

    public static ResourceLocation[] getTextureGroup(String name) {
        if (!textureGroups.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return textureGroups.get(name);
    }

    public static SoundEvent getSound(String name) {
        if (!sounds.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return sounds.get(name);
    }

    public static ModelBase getModel(String name) {
        name = name.toLowerCase();
        CreatureInfo creatureInfo = CreatureManager.getInstance().getCreatureFromId(name);
        if (creatureInfo != null) {
            // empty if block
        }
        if (!models.containsKey(name)) {
            return null;
        }
        return models.get(name);
    }

    public static ModelBase getCreatureModel(BaseCreatureEntity entityCreature) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (entityCreature.creatureInfo == null) {
            return null;
        }
        if (entityCreature.getSubspecies() != null && entityCreature.getSubspecies().modelClass != null) {
            if (models.containsKey(entityCreature.getSubspecies().modelClass.toString())) {
                return models.get(entityCreature.getSubspecies().modelClass.toString());
            }
            ModelBase creatureModel = entityCreature.getSubspecies().modelClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            models.put(entityCreature.getSubspecies().modelClass.toString(), creatureModel);
            return creatureModel;
        }
        return AssetManager.getCreatureModel(entityCreature.creatureInfo);
    }

    public static ModelBase getCreatureModel(CreatureInfo creatureInfo) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (creatureInfo == null || creatureInfo.modelClass == null) {
            return null;
        }
        if (models.containsKey(creatureInfo.modelClass.toString())) {
            return models.get(creatureInfo.modelClass.toString());
        }
        ModelBase creatureModel = creatureInfo.modelClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        models.put(creatureInfo.modelClass.toString(), creatureModel);
        return creatureModel;
    }

    public static ModelBase getProjectileModel(ProjectileInfo projectileInfo) {
        if (projectileModels.containsKey(projectileInfo)) {
            return projectileModels.get(projectileInfo);
        }
        return null;
    }

    public static IModel getObjModel(String name) {
        if (!objModels.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return objModels.get(name);
    }

    public static IModel getObjModel(String name, ModInfo modInfo, String path) {
        if (!objModels.containsKey(name = name.toLowerCase())) {
            AssetManager.addObjModel(name, modInfo, path);
        }
        return objModels.get(name);
    }

    public static ModelItemBase getItemModel(String name) {
        if (!itemModels.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return itemModels.get(name);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels() {
        for (Item item : ObjectManager.items.values()) {
            ItemBase itemBase;
            if (item instanceof ItemBase && (itemBase = (ItemBase)item).useItemColors()) {
                Minecraft.func_71410_x().getItemColors().func_186730_a(ClientProxy.itemColor, new Item[]{item});
            }
            if (!(item instanceof ItemEquipmentPart)) continue;
            ItemEquipmentPart itemEquipmentPart = (ItemEquipmentPart)item;
            AssetManager.addItemModel(itemEquipmentPart.itemName, new ModelEquipmentPart(itemEquipmentPart.itemName, itemEquipmentPart.modInfo));
        }
        for (ProjectileInfo projectileInfo : ProjectileManager.getInstance().projectiles.values()) {
            if (projectileInfo.modelClassName == null) continue;
            try {
                projectileModels.put(projectileInfo, (ModelBase)Class.forName(projectileInfo.modelClassName).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "Unable to load a Projectile model, check that the model class name is correct in the associated projectile json.");
                e.printStackTrace();
            }
        }
    }
}

