/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.template.ModelTemplateElemental;
import com.lycanitesmobs.client.renderer.RenderCreature;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureEffect;
import javax.vecmath.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelReiver
extends ModelTemplateElemental {
    float maxLeg = 0.0f;

    public ModelReiver() {
        this(1.0f);
    }

    public ModelReiver(float shadowSize) {
        this.initModel("reiver", LycanitesMobs.modInfo, "entity/reiver");
        this.trophyScale = 1.0f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.2f};
    }

    @Override
    public void addCustomLayers(RenderCreature renderer) {
        super.addCustomLayers(renderer);
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "pulse01", false, LayerCreatureEffect.BLEND.NORMAL.id, false));
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "pulse02", false, LayerCreatureEffect.BLEND.NORMAL.id, false));
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "pulse03", false, LayerCreatureEffect.BLEND.NORMAL.id, false));
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        if (partName.contains("effect")) {
            this.rotate(25.0f, 0.0f, 0.0f);
        }
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
    }

    @Override
    public Vector4f getPartColor(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        if (layer == null) {
            return super.getPartColor(partName, entity, layer, trophy, loop);
        }
        float alphaSpeed = 10.0f;
        if ("pulse02".equals(layer.name)) {
            alphaSpeed = 9.5f;
            loop += 100.0f;
        }
        if ("pulse03".equals(layer.name)) {
            alphaSpeed = 9.0f;
            loop += 200.0f;
        }
        float alpha = loop * alphaSpeed % 360.0f;
        return new Vector4f(1.0f, 1.0f, 1.0f, (float)Math.cos(Math.toRadians(alpha)) / 2.0f + 0.5f);
    }
}

