/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.renderer;

import com.lycanitesmobs.client.renderer.RenderProjectileModel;
import com.lycanitesmobs.client.renderer.RenderProjectileSprite;
import com.lycanitesmobs.core.entity.CustomProjectileEntity;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderFactoryProjectile<T extends Entity>
implements IRenderFactory {
    protected String oldProjectileName;
    protected Class oldProjectileClass;
    protected boolean oldModel;
    protected boolean hasModel;

    public RenderFactoryProjectile(boolean hasModel) {
        this.hasModel = hasModel;
    }

    public RenderFactoryProjectile(String projectileName, Class projectileClass, boolean hasModel) {
        this.oldProjectileName = projectileName;
        this.oldProjectileClass = projectileClass;
        this.oldModel = hasModel;
    }

    public Render createRenderFor(RenderManager manager) {
        if (this.oldModel) {
            try {
                return new RenderProjectileModel(manager, this.oldProjectileName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.oldProjectileClass != null) {
            return new RenderProjectileSprite(manager, this.oldProjectileClass);
        }
        if (this.hasModel) {
            try {
                return new RenderProjectileModel(manager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new RenderProjectileSprite(manager, CustomProjectileEntity.class);
    }
}

