/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.container;

import com.lycanitesmobs.core.container.BaseSlot;
import com.lycanitesmobs.core.container.EquipmentForgeContainer;
import com.lycanitesmobs.core.inventory.InventoryCreature;
import com.lycanitesmobs.core.item.equipment.ItemEquipment;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.SlotEquipmentFeature;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class EquipmentForgeSlot
extends BaseSlot {
    public String type;
    public EquipmentForgeContainer containerForge;
    public List<EquipmentForgeSlot> childSlots = new ArrayList<EquipmentForgeSlot>();

    public EquipmentForgeSlot(EquipmentForgeContainer containerForge, int slotIndex, int x, int y, String type) {
        super(containerForge.equipmentForge, slotIndex, x, y);
        this.containerForge = containerForge;
        this.type = type;
    }

    @Override
    public boolean func_75214_a(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemEquipmentPart) {
            ItemEquipmentPart equipmentPart = (ItemEquipmentPart)item;
            return this.type.equals(equipmentPart.slotType) && equipmentPart.getLevel(itemStack) <= this.containerForge.equipmentForge.getLevel();
        }
        if (item instanceof ItemEquipment) {
            ItemEquipment equipment;
            int equipmentLevel;
            if (this.containerForge.equipmentForge.getLevel() < 3 && (equipmentLevel = (equipment = (ItemEquipment)item).getHighestLevel(itemStack)) > this.containerForge.equipmentForge.getLevel()) {
                return false;
            }
            return this.type.equals("piece") && !this.func_75216_d();
        }
        return false;
    }

    public boolean func_75216_d() {
        ItemEquipment itemEquipment;
        if (!super.func_75216_d()) {
            return false;
        }
        return !(this.func_75211_c().func_77973_b() instanceof ItemEquipment) || (itemEquipment = (ItemEquipment)this.func_75211_c().func_77973_b()).getEquipmentPartCount(this.func_75211_c()) != 0;
    }

    @Override
    public int func_75219_a() {
        if (this.field_75224_c instanceof InventoryCreature && ((InventoryCreature)this.field_75224_c).getTypeFromSlot(this.getSlotIndex()) != null) {
            return 1;
        }
        return this.field_75224_c.func_70297_j_();
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addChildSlot(EquipmentForgeSlot slot) {
        if (this.childSlots.contains((Object)slot)) {
            return;
        }
        this.childSlots.add(slot);
        this.updateChildSlots();
    }

    public boolean updateChildSlot(int index, String type) {
        if (index >= this.childSlots.size()) {
            return false;
        }
        this.childSlots.get(index).setType(type);
        return true;
    }

    public void func_75215_d(ItemStack itemStack) {
        this.putStackWithoutUpdate(itemStack);
        if ("piece".equals(this.type)) {
            this.containerForge.onEquipmentPieceSlotChanged(this);
        } else {
            this.containerForge.onEquipmentPartSlotChanged(this);
        }
    }

    public void putStackWithoutUpdate(ItemStack itemStack) {
        super.func_75215_d(itemStack);
        if (!this.childSlots.isEmpty()) {
            this.updateChildSlots();
        }
    }

    public ItemStack func_190901_a(EntityPlayer player, ItemStack itemStack) {
        int forgeLevel;
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemEquipmentPart) {
            this.updateChildSlots();
        }
        if (item instanceof ItemEquipment && (forgeLevel = this.containerForge.equipmentForge.getLevel()) < 3) {
            ((ItemEquipment)item).applyLevelCap(itemStack, this.containerForge.equipmentForge.getLevel());
        }
        if ("piece".equals(this.type)) {
            this.containerForge.onEquipmentPieceSlotChanged(this);
        } else {
            this.containerForge.onEquipmentPartSlotChanged(this);
        }
        return super.func_190901_a(player, itemStack);
    }

    public boolean func_82869_a(EntityPlayer player) {
        if (!this.childSlots.isEmpty()) {
            for (EquipmentForgeSlot childSlot : this.childSlots) {
                if (childSlot.func_75211_c().func_190926_b()) continue;
                return false;
            }
        } else if ("piece".equals(this.type) && this.func_75216_d() && !this.containerForge.isEquipmentValid()) {
            return false;
        }
        return true;
    }

    public void updateChildSlots() {
        Item item = this.func_75211_c().func_77973_b();
        ArrayList<Integer> updatedChildSlots = new ArrayList<Integer>();
        if (item instanceof ItemEquipmentPart) {
            ItemEquipmentPart itemEquipmentPart = (ItemEquipmentPart)item;
            int axeSlots = 0;
            for (EquipmentFeature feature : itemEquipmentPart.features) {
                if (!(feature instanceof SlotEquipmentFeature)) continue;
                SlotEquipmentFeature slotFeature = (SlotEquipmentFeature)feature;
                int level = itemEquipmentPart.getLevel(this.func_75211_c());
                if (!slotFeature.isActive(this.func_75211_c(), level)) continue;
                int index = 0;
                if (slotFeature.slotType.equals("axe")) {
                    index = ++axeSlots;
                } else if (slotFeature.slotType.equals("pommel")) {
                    index = 1;
                }
                if (updatedChildSlots.contains(index) || !this.updateChildSlot(index, slotFeature.slotType)) continue;
                updatedChildSlots.add(index);
            }
        }
        for (int index = 0; index < this.childSlots.size(); ++index) {
            if (updatedChildSlots.contains(index)) continue;
            this.updateChildSlot(index, "none");
        }
    }
}

