/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.dungeon.instance;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.block.BlockFireBase;
import com.lycanitesmobs.core.block.effect.BlockFrostCloud;
import com.lycanitesmobs.core.block.effect.BlockPoisonCloud;
import com.lycanitesmobs.core.dungeon.definition.DungeonSector;
import com.lycanitesmobs.core.dungeon.definition.DungeonTheme;
import com.lycanitesmobs.core.dungeon.definition.SectorLayer;
import com.lycanitesmobs.core.dungeon.instance.DungeonLayout;
import com.lycanitesmobs.core.dungeon.instance.SectorConnector;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.spawner.MobSpawn;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

public class SectorInstance {
    public DungeonLayout layout;
    public DungeonSector dungeonSector;
    public SectorConnector parentConnector;
    public List<SectorConnector> connectors = new ArrayList<SectorConnector>();
    protected Vec3i roomSize;
    protected Vec3i occupiedSize;
    public DungeonTheme theme;
    public IBlockState lightBlock;
    public IBlockState torchBlock;
    public IBlockState stairBlock;
    public IBlockState pitBlock;
    public int chunksBuilt = 0;

    public SectorInstance(DungeonLayout layout, DungeonSector dungeonSector, Random random) {
        this.layout = layout;
        this.dungeonSector = dungeonSector;
        this.roomSize = this.dungeonSector.getRandomSize(random);
        this.occupiedSize = new Vec3i(this.roomSize.func_177958_n() + Math.max(1, this.dungeonSector.padding.func_177958_n()), this.roomSize.func_177956_o() + this.dungeonSector.padding.func_177956_o(), this.roomSize.func_177952_p() + Math.max(1, this.dungeonSector.padding.func_177952_p()));
    }

    public void connect(SectorConnector parentConnector) {
        this.parentConnector = parentConnector;
    }

    public void init(Random random) {
        int y;
        if (this.parentConnector == null) {
            throw new RuntimeException("[Dungeon] Tried to initialise a Sector Instance with a null Parent Connector: " + this);
        }
        this.parentConnector.childSector = this;
        this.parentConnector.closed = true;
        this.layout.openConnectors.remove(this.parentConnector);
        this.theme = this.dungeonSector.changeTheme || this.parentConnector.parentSector == null ? this.layout.dungeonInstance.schematic.getRandomTheme(random) : this.parentConnector.parentSector.theme;
        this.lightBlock = this.theme.getLight('B', random);
        this.torchBlock = this.theme.getTorch('B', random);
        this.stairBlock = this.theme.getStairs('B', random);
        this.pitBlock = this.theme.getPit('B', random);
        BlockPos boundsMin = this.getRoomBoundsMin();
        BlockPos boundsMax = this.getRoomBoundsMax();
        Vec3i size = this.getRoomSize();
        int centerX = boundsMin.func_177958_n() + Math.round((float)size.func_177958_n() / 2.0f);
        int centerZ = boundsMin.func_177952_p() + Math.round((float)size.func_177952_p() / 2.0f);
        int upperConnectorY = this.parentConnector.position.func_177956_o() + this.getRoomSize().func_177956_o();
        if (upperConnectorY < 255) {
            BlockPos blockPos = new BlockPos(centerX, upperConnectorY, centerZ);
            this.addConnector(blockPos, this.parentConnector.level + 1, EnumFacing.UP);
        }
        if ("corridor".equalsIgnoreCase(this.dungeonSector.type) || "room".equalsIgnoreCase(this.dungeonSector.type) || "tower".equalsIgnoreCase(this.dungeonSector.type) || "entrance".equalsIgnoreCase(this.dungeonSector.type) || "bossRoom".equalsIgnoreCase(this.dungeonSector.type)) {
            BlockPos frontPos = this.parentConnector.position;
            EnumFacing frontFacing = EnumFacing.SOUTH;
            BlockPos backPos = this.parentConnector.position;
            EnumFacing backFacing = EnumFacing.NORTH;
            if (this.parentConnector.facing == EnumFacing.SOUTH || this.parentConnector.facing == EnumFacing.UP) {
                frontPos = new BlockPos(this.getConnectorOffset(random, size.func_177958_n(), boundsMin.func_177958_n()), this.parentConnector.position.func_177956_o(), boundsMax.func_177952_p() + 1);
                frontFacing = EnumFacing.SOUTH;
                backPos = new BlockPos(this.getConnectorOffset(random, size.func_177958_n(), boundsMin.func_177958_n()), this.parentConnector.position.func_177956_o(), boundsMin.func_177952_p() - 1);
                backFacing = EnumFacing.NORTH;
            } else if (this.parentConnector.facing == EnumFacing.EAST) {
                frontPos = new BlockPos(boundsMax.func_177958_n() + 1, this.parentConnector.position.func_177956_o(), this.getConnectorOffset(random, size.func_177952_p(), boundsMin.func_177952_p()));
                frontFacing = EnumFacing.EAST;
                backPos = new BlockPos(boundsMin.func_177958_n() - 1, this.parentConnector.position.func_177956_o(), this.getConnectorOffset(random, size.func_177952_p(), boundsMin.func_177952_p()));
                backFacing = EnumFacing.WEST;
            } else if (this.parentConnector.facing == EnumFacing.NORTH) {
                frontPos = new BlockPos(this.getConnectorOffset(random, size.func_177958_n(), boundsMin.func_177958_n()), this.parentConnector.position.func_177956_o(), boundsMin.func_177952_p() - 1);
                frontFacing = EnumFacing.NORTH;
                backPos = new BlockPos(this.getConnectorOffset(random, size.func_177958_n(), boundsMin.func_177958_n()), this.parentConnector.position.func_177956_o(), boundsMax.func_177952_p() + 1);
                backFacing = EnumFacing.SOUTH;
            } else if (this.parentConnector.facing == EnumFacing.WEST) {
                frontPos = new BlockPos(boundsMin.func_177958_n() - 1, this.parentConnector.position.func_177956_o(), this.getConnectorOffset(random, size.func_177952_p(), boundsMin.func_177952_p()));
                frontFacing = EnumFacing.WEST;
                backPos = new BlockPos(boundsMax.func_177958_n() + 1, this.parentConnector.position.func_177956_o(), this.getConnectorOffset(random, size.func_177952_p(), boundsMin.func_177952_p()));
                backFacing = EnumFacing.EAST;
            }
            this.addConnector(frontPos, this.parentConnector.level, frontFacing);
            if ("tower".equalsIgnoreCase(this.dungeonSector.type)) {
                this.addConnector(backPos, this.parentConnector.level, backFacing);
            }
            if ("room".equalsIgnoreCase(this.dungeonSector.type) || "tower".equalsIgnoreCase(this.dungeonSector.type)) {
                BlockPos leftPos = this.parentConnector.position;
                EnumFacing leftFacing = EnumFacing.WEST;
                BlockPos rightPos = this.parentConnector.position;
                EnumFacing rightFacing = EnumFacing.EAST;
                if (this.parentConnector.facing == EnumFacing.SOUTH || this.parentConnector.facing == EnumFacing.NORTH || this.parentConnector.facing == EnumFacing.UP) {
                    leftPos = new BlockPos(boundsMin.func_177958_n() - 1, this.parentConnector.position.func_177956_o(), this.getConnectorOffset(random, size.func_177952_p(), boundsMin.func_177952_p()));
                    leftFacing = EnumFacing.WEST;
                    rightPos = new BlockPos(boundsMax.func_177958_n() + 1, this.parentConnector.position.func_177956_o(), this.getConnectorOffset(random, size.func_177952_p(), boundsMin.func_177952_p()));
                    rightFacing = EnumFacing.EAST;
                } else if (this.parentConnector.facing == EnumFacing.EAST || this.parentConnector.facing == EnumFacing.WEST) {
                    leftPos = new BlockPos(this.getConnectorOffset(random, size.func_177958_n(), boundsMin.func_177958_n()), this.parentConnector.position.func_177956_o(), boundsMax.func_177952_p() + 1);
                    leftFacing = EnumFacing.SOUTH;
                    rightPos = new BlockPos(this.getConnectorOffset(random, size.func_177958_n(), boundsMin.func_177958_n()), this.parentConnector.position.func_177956_o(), boundsMin.func_177952_p() - 1);
                    rightFacing = EnumFacing.NORTH;
                }
                this.addConnector(leftPos, this.parentConnector.level, leftFacing);
                this.addConnector(rightPos, this.parentConnector.level, rightFacing);
            }
        }
        if ("stairs".equalsIgnoreCase(this.dungeonSector.type) && (y = this.parentConnector.position.func_177956_o() - size.func_177956_o() * 2) > 0) {
            BlockPos blockPos = new BlockPos(centerX, y, boundsMax.func_177952_p() + 1);
            if (this.parentConnector.facing == EnumFacing.EAST) {
                blockPos = new BlockPos(boundsMax.func_177958_n() + 1, y, centerZ);
            } else if (this.parentConnector.facing == EnumFacing.NORTH) {
                blockPos = new BlockPos(centerX, y, boundsMin.func_177952_p() - 1);
            } else if (this.parentConnector.facing == EnumFacing.WEST) {
                blockPos = new BlockPos(boundsMin.func_177958_n() - 1, y, centerZ);
            }
            this.addConnector(blockPos, this.parentConnector.level - 1, this.parentConnector.facing);
        }
    }

    public int getConnectorOffset(Random random, int length, int start) {
        int entrancePadding = 2;
        if (!"room".equalsIgnoreCase(this.dungeonSector.type) || length <= entrancePadding * 2) {
            return start + Math.round((float)length / 2.0f);
        }
        return start + entrancePadding + random.nextInt(length - entrancePadding * 2) + 1;
    }

    public SectorConnector addConnector(BlockPos blockPos, int level, EnumFacing facing) {
        SectorConnector connector = new SectorConnector(blockPos, this, level, facing);
        this.connectors.add(connector);
        return connector;
    }

    public SectorConnector getRandomConnector(Random random, SectorInstance sectorInstance) {
        List<SectorConnector> openConnectors = this.getOpenConnectors(sectorInstance);
        if (openConnectors.isEmpty()) {
            return null;
        }
        if (openConnectors.size() == 1) {
            return openConnectors.get(0);
        }
        return openConnectors.get(random.nextInt(openConnectors.size()));
    }

    public List<SectorConnector> getOpenConnectors(SectorInstance sectorInstance) {
        ArrayList<SectorConnector> openConnectors = new ArrayList<SectorConnector>();
        for (SectorConnector connector : this.connectors) {
            if (!connector.canConnect(this.layout, sectorInstance)) continue;
            openConnectors.add(connector);
        }
        return openConnectors;
    }

    public List<ChunkPos> getChunkPositions() {
        ChunkPos minChunkPos = new ChunkPos(this.getOccupiedBoundsMin().func_177982_a(-9, 0, -9));
        ChunkPos maxChunkPos = new ChunkPos(this.getOccupiedBoundsMax().func_177982_a(-7, 0, -7));
        ArrayList<ChunkPos> chunkPosList = new ArrayList<ChunkPos>();
        for (int x = minChunkPos.field_77276_a; x <= maxChunkPos.field_77276_a; ++x) {
            for (int z = minChunkPos.field_77275_b; z <= maxChunkPos.field_77275_b; ++z) {
                chunkPosList.add(new ChunkPos(x, z));
            }
        }
        return chunkPosList;
    }

    public List<SectorInstance> getNearbySectors() {
        ArrayList<SectorInstance> nearbySectors = new ArrayList<SectorInstance>();
        for (SectorInstance nearbySector : this.layout.sectors) {
            if (nearbySectors.contains(nearbySector)) continue;
            nearbySectors.add(nearbySector);
        }
        return nearbySectors;
    }

    public boolean collidesWith(SectorInstance sectorInstance) {
        boolean withinZ;
        boolean withinX;
        if (sectorInstance == this || sectorInstance == this.parentConnector.parentSector) {
            return false;
        }
        BlockPos boundsMin = this.getOccupiedBoundsMin();
        BlockPos boundsMax = this.getOccupiedBoundsMax();
        BlockPos targetMin = sectorInstance.getOccupiedBoundsMin();
        BlockPos targetMax = sectorInstance.getOccupiedBoundsMax();
        if (boundsMin.func_177956_o() != targetMin.func_177956_o() && !sectorInstance.dungeonSector.type.equals("stairs")) {
            return false;
        }
        boolean bl = withinX = boundsMin.func_177958_n() >= targetMin.func_177958_n() && boundsMin.func_177958_n() <= targetMax.func_177958_n();
        if (!withinX) {
            boolean bl2 = withinX = boundsMax.func_177958_n() >= targetMin.func_177958_n() && boundsMax.func_177958_n() <= targetMax.func_177958_n();
        }
        if (!withinX) {
            return false;
        }
        boolean bl3 = withinZ = boundsMin.func_177952_p() >= targetMin.func_177952_p() && boundsMin.func_177952_p() <= targetMax.func_177952_p();
        if (!withinZ) {
            boolean bl4 = withinZ = boundsMax.func_177952_p() >= targetMin.func_177952_p() && boundsMax.func_177952_p() <= targetMax.func_177952_p();
        }
        return withinZ;
    }

    public Vec3i getRoomSize() {
        if (this.parentConnector.facing == EnumFacing.EAST || this.parentConnector.facing == EnumFacing.WEST) {
            return new Vec3i(this.roomSize.func_177952_p(), this.roomSize.func_177956_o(), this.roomSize.func_177958_n());
        }
        return this.roomSize;
    }

    public Vec3i getOccupiedSize() {
        if (this.parentConnector.facing == EnumFacing.EAST || this.parentConnector.facing == EnumFacing.WEST) {
            return new Vec3i(this.occupiedSize.func_177952_p(), this.occupiedSize.func_177956_o(), this.occupiedSize.func_177958_n());
        }
        return this.occupiedSize;
    }

    public BlockPos getBoundsMin(Vec3i boundsSize) {
        BlockPos bounds = new BlockPos((Vec3i)this.parentConnector.position);
        if (this.parentConnector.facing == EnumFacing.UP) {
            bounds = bounds.func_177982_a(-((int)Math.ceil((double)boundsSize.func_177958_n() / 2.0)), 0, -((int)Math.ceil((double)boundsSize.func_177952_p() / 2.0)));
        } else if (this.parentConnector.facing == EnumFacing.SOUTH) {
            bounds = bounds.func_177982_a(-((int)Math.ceil((double)boundsSize.func_177958_n() / 2.0)), 0, 0);
        } else if (this.parentConnector.facing == EnumFacing.EAST) {
            bounds = bounds.func_177982_a(0, 0, -((int)Math.ceil((double)boundsSize.func_177952_p() / 2.0)));
        } else if (this.parentConnector.facing == EnumFacing.NORTH) {
            bounds = bounds.func_177982_a(-((int)Math.ceil((double)boundsSize.func_177958_n() / 2.0)), 0, -boundsSize.func_177952_p());
        } else if (this.parentConnector.facing == EnumFacing.WEST) {
            bounds = bounds.func_177982_a(-boundsSize.func_177958_n(), 0, -((int)Math.ceil((double)boundsSize.func_177952_p() / 2.0)));
        }
        return bounds;
    }

    public BlockPos getBoundsMax(Vec3i boundsSize) {
        BlockPos bounds = new BlockPos((Vec3i)this.parentConnector.position);
        if (this.parentConnector.facing == EnumFacing.UP) {
            bounds = bounds.func_177982_a((int)Math.ceil((double)boundsSize.func_177958_n() / 2.0), boundsSize.func_177956_o(), (int)Math.ceil((double)boundsSize.func_177952_p() / 2.0));
        } else if (this.parentConnector.facing == EnumFacing.SOUTH) {
            bounds = bounds.func_177982_a((int)Math.floor((double)boundsSize.func_177958_n() / 2.0), boundsSize.func_177956_o(), boundsSize.func_177952_p());
        } else if (this.parentConnector.facing == EnumFacing.EAST) {
            bounds = bounds.func_177982_a(boundsSize.func_177958_n(), boundsSize.func_177956_o(), (int)Math.floor((double)boundsSize.func_177952_p() / 2.0));
        } else if (this.parentConnector.facing == EnumFacing.NORTH) {
            bounds = bounds.func_177982_a((int)Math.floor((double)boundsSize.func_177958_n() / 2.0), boundsSize.func_177956_o(), 0);
        } else if (this.parentConnector.facing == EnumFacing.WEST) {
            bounds = bounds.func_177982_a(0, boundsSize.func_177956_o(), (int)Math.floor((double)boundsSize.func_177952_p() / 2.0));
        }
        return bounds;
    }

    public BlockPos getOccupiedBoundsMin() {
        BlockPos occupiedBoundsMin = this.getBoundsMin(this.getOccupiedSize());
        if ("stairs".equals(this.dungeonSector.type)) {
            occupiedBoundsMin = occupiedBoundsMin.func_177973_b(new Vec3i(0, this.getRoomSize().func_177956_o() * 2, 0));
        }
        return occupiedBoundsMin;
    }

    public BlockPos getOccupiedBoundsMax() {
        return this.getBoundsMax(this.getOccupiedSize());
    }

    public BlockPos getRoomBoundsMin() {
        return this.getBoundsMin(this.getRoomSize());
    }

    public BlockPos getRoomBoundsMax() {
        return this.getBoundsMax(this.getRoomSize());
    }

    public BlockPos getCenter() {
        BlockPos startPos = this.getRoomBoundsMin();
        BlockPos stopPos = this.getRoomBoundsMax();
        Vec3i size = this.getRoomSize();
        int centerX = startPos.func_177958_n() + Math.round((float)size.func_177958_n() / 2.0f);
        int centerZ = startPos.func_177952_p() + Math.round((float)size.func_177952_p() / 2.0f);
        return new BlockPos(centerX, startPos.func_177956_o(), centerZ);
    }

    public void placeBlock(World world, ChunkPos chunkPos, BlockPos blockPos, IBlockState blockState, EnumFacing facing, Random random) {
        TileEntity tileEntity;
        int chunkOffset = 8;
        if (blockPos.func_177958_n() < chunkPos.func_180334_c() + chunkOffset || blockPos.func_177958_n() > chunkPos.func_180332_e() + chunkOffset) {
            return;
        }
        if (blockPos.func_177956_o() <= 0 || blockPos.func_177956_o() >= world.func_72800_K()) {
            return;
        }
        if (blockPos.func_177952_p() < chunkPos.func_180333_d() + chunkOffset || blockPos.func_177952_p() > chunkPos.func_180330_f() + chunkOffset) {
            return;
        }
        if (blockState.func_177230_c() == Blocks.field_150350_a && world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150486_ae) {
            return;
        }
        int flags = 3;
        if (blockState.func_177230_c() == Blocks.field_150478_aa) {
            blockState = blockState.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing);
            flags = 0;
        }
        if (blockState.func_177230_c() == Blocks.field_150486_ae) {
            blockState = blockState.func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing);
        }
        if (blockState.func_177230_c() == Blocks.field_150350_a || blockState.func_177230_c() instanceof BlockFluidBase || blockState.func_177230_c() instanceof BlockFire || blockState.func_177230_c() instanceof BlockFireBase || blockState.func_177230_c() instanceof BlockPoisonCloud || blockState.func_177230_c() instanceof BlockFrostCloud) {
            flags = 0;
        }
        world.func_180501_a(blockPos, blockState, flags);
        if (blockState.func_177230_c() == Blocks.field_150474_ac) {
            TileEntity tileEntity2 = world.func_175625_s(blockPos);
            if (tileEntity2 != null && tileEntity2 instanceof TileEntityMobSpawner) {
                ResourceLocation entityId;
                TileEntityMobSpawner spawner = (TileEntityMobSpawner)tileEntity2;
                MobSpawn mobSpawn = this.layout.dungeonInstance.schematic.getRandomMobSpawn(this.parentConnector.level, false, random);
                if (mobSpawn != null && (entityId = EntityList.func_191306_a((Class)mobSpawn.entityClass)) != null) {
                    spawner.func_145881_a().func_190894_a(entityId);
                }
            }
            return;
        }
        if (blockState.func_177230_c() == Blocks.field_150486_ae && (tileEntity = world.func_175625_s(blockPos)) instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)tileEntity;
            ResourceLocation lootTable = this.layout.dungeonInstance.schematic.getRandomLootTable(this.parentConnector.level, random);
            if (lootTable != null) {
                chest.func_189404_a(lootTable, random.nextLong());
            }
        }
    }

    public void build(World world, ChunkPos chunkPos, Random random) {
        MobSpawn mobSpawn;
        this.clearArea(world, chunkPos, random);
        this.buildFloor(world, chunkPos, random, 0);
        this.buildWalls(world, chunkPos, random);
        this.buildCeiling(world, chunkPos, random);
        if ("stairs".equalsIgnoreCase(this.dungeonSector.type)) {
            this.buildStairs(world, chunkPos, random);
            this.buildFloor(world, chunkPos, random, -(this.getRoomSize().func_177956_o() * 2));
        }
        if ("tower".equalsIgnoreCase(this.dungeonSector.type)) {
            this.buildStairs(world, chunkPos, random);
        }
        this.buildEntrances(world, chunkPos, random);
        ++this.chunksBuilt;
        if ("bossRoom".equalsIgnoreCase(this.dungeonSector.type) && (mobSpawn = this.layout.dungeonInstance.schematic.getRandomMobSpawn(this.parentConnector.level, true, random)) != null) {
            this.spawnMob(world, chunkPos, this.getCenter().func_177982_a(0, 1, 0), mobSpawn, random);
        }
    }

    public void clearArea(World world, ChunkPos chunkPos, Random random) {
        BlockPos startPos = this.getRoomBoundsMin();
        BlockPos stopPos = this.getRoomBoundsMax();
        int startX = Math.min(startPos.func_177958_n(), stopPos.func_177958_n());
        int stopX = Math.max(startPos.func_177958_n(), stopPos.func_177958_n());
        int startY = Math.min(startPos.func_177956_o(), stopPos.func_177956_o());
        int stopY = Math.max(startPos.func_177956_o(), stopPos.func_177956_o());
        int startZ = Math.min(startPos.func_177952_p(), stopPos.func_177952_p());
        int stopZ = Math.max(startPos.func_177952_p(), stopPos.func_177952_p());
        if ("stairs".equalsIgnoreCase(this.dungeonSector.type)) {
            startY = Math.max(1, startPos.func_177956_o() - this.getRoomSize().func_177956_o() * 2);
        }
        for (int x = startX; x <= stopX; ++x) {
            for (int y = startY; y <= stopY; ++y) {
                for (int z = startZ; z <= stopZ; ++z) {
                    this.placeBlock(world, chunkPos, new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), EnumFacing.SOUTH, random);
                }
            }
        }
    }

    public void buildFloor(World world, ChunkPos chunkPos, Random random, int offsetY) {
        BlockPos startPos = this.getRoomBoundsMin().func_177982_a(0, offsetY, 0);
        BlockPos stopPos = this.getRoomBoundsMax().func_177982_a(0, offsetY, 0);
        int startX = Math.min(startPos.func_177958_n(), stopPos.func_177958_n());
        int stopX = Math.max(startPos.func_177958_n(), stopPos.func_177958_n());
        int startY = Math.min(startPos.func_177956_o(), stopPos.func_177956_o());
        int stopY = Math.max(startPos.func_177956_o(), stopPos.func_177956_o());
        int startZ = Math.min(startPos.func_177952_p(), stopPos.func_177952_p());
        int stopZ = Math.max(startPos.func_177952_p(), stopPos.func_177952_p());
        for (int layerIndex : this.dungeonSector.floor.layers.keySet()) {
            int y = startY + layerIndex;
            if (y <= 0 || y >= world.func_72800_K()) continue;
            SectorLayer layer = this.dungeonSector.floor.layers.get(layerIndex);
            for (int x = startX; x <= stopX; ++x) {
                List<Character> row = layer.getRow(x - startX, stopX - startX);
                for (int z = startZ; z <= stopZ; ++z) {
                    char buildChar = layer.getColumn(x - startX, stopX - startX, z - startZ, stopZ - startZ, row).charValue();
                    BlockPos buildPos = new BlockPos(x, y, z);
                    IBlockState blockState = this.theme.getFloor(this, buildChar, random);
                    if (blockState.func_177230_c() == Blocks.field_150350_a) continue;
                    this.placeBlock(world, chunkPos, buildPos, blockState, EnumFacing.UP, random);
                }
            }
        }
    }

    public void buildWalls(World world, ChunkPos chunkPos, Random random) {
        BlockPos startPos = this.getRoomBoundsMin();
        BlockPos stopPos = this.getRoomBoundsMax();
        Vec3i size = this.getRoomSize();
        int startX = Math.min(startPos.func_177958_n(), stopPos.func_177958_n());
        int stopX = Math.max(startPos.func_177958_n(), stopPos.func_177958_n());
        int startY = Math.min(startPos.func_177956_o() + 1, stopPos.func_177956_o());
        int stopY = Math.max(startPos.func_177956_o() - 1, stopPos.func_177956_o());
        int startZ = Math.min(startPos.func_177952_p(), stopPos.func_177952_p());
        int stopZ = Math.max(startPos.func_177952_p(), stopPos.func_177952_p());
        if ("stairs".equalsIgnoreCase(this.dungeonSector.type)) {
            startY = Math.max(1, startPos.func_177956_o() - size.func_177956_o() * 2);
        }
        for (int layerIndex : this.dungeonSector.wall.layers.keySet()) {
            SectorLayer layer = this.dungeonSector.wall.layers.get(layerIndex);
            for (int y = startY; y <= stopY; ++y) {
                IBlockState blockState;
                char buildChar;
                if (y <= 0 || y >= world.func_72800_K()) continue;
                int progressY = y - startY;
                int fullY = stopY - startY;
                List<Character> row = layer.getRow(progressY, fullY);
                for (int x = startX; x <= stopX; ++x) {
                    buildChar = layer.getColumn(progressY, fullY, x - startX, stopX - startX, row).charValue();
                    blockState = this.theme.getWall(this, buildChar, random);
                    if (blockState.func_177230_c() == Blocks.field_150350_a) continue;
                    this.placeBlock(world, chunkPos, new BlockPos(x, y, startZ + layerIndex), blockState, EnumFacing.SOUTH, random);
                    this.placeBlock(world, chunkPos, new BlockPos(x, y, stopZ - layerIndex), blockState, EnumFacing.NORTH, random);
                }
                for (int z = startZ; z <= stopZ; ++z) {
                    buildChar = layer.getColumn(progressY, fullY, z - startZ, stopZ - startZ, row).charValue();
                    blockState = this.theme.getWall(this, buildChar, random);
                    if (blockState.func_177230_c() == Blocks.field_150350_a) continue;
                    this.placeBlock(world, chunkPos, new BlockPos(startX + layerIndex, y, z), blockState, EnumFacing.EAST, random);
                    this.placeBlock(world, chunkPos, new BlockPos(stopX - layerIndex, y, z), blockState, EnumFacing.WEST, random);
                }
            }
        }
    }

    public void buildCeiling(World world, ChunkPos chunkPos, Random random) {
        BlockPos startPos = this.getRoomBoundsMin();
        BlockPos stopPos = this.getRoomBoundsMax();
        int startX = Math.min(startPos.func_177958_n(), stopPos.func_177958_n());
        int stopX = Math.max(startPos.func_177958_n(), stopPos.func_177958_n());
        int startY = Math.min(startPos.func_177956_o(), stopPos.func_177956_o());
        int stopY = Math.max(startPos.func_177956_o(), stopPos.func_177956_o());
        int startZ = Math.min(startPos.func_177952_p(), stopPos.func_177952_p());
        int stopZ = Math.max(startPos.func_177952_p(), stopPos.func_177952_p());
        for (int layerIndex : this.dungeonSector.ceiling.layers.keySet()) {
            int y = stopY + layerIndex;
            if (y <= 0 || y >= world.func_72800_K()) continue;
            SectorLayer layer = this.dungeonSector.ceiling.layers.get(layerIndex);
            for (int x = startX; x <= stopX; ++x) {
                List<Character> row = layer.getRow(x - startX, stopX - startX);
                for (int z = startZ; z <= stopZ; ++z) {
                    char buildChar = layer.getColumn(x - startX, stopX - startX, z - startZ, stopZ - startZ, row).charValue();
                    BlockPos buildPos = new BlockPos(x, y, z);
                    IBlockState blockState = this.theme.getCeiling(this, buildChar, random);
                    if (blockState.func_177230_c() == Blocks.field_150350_a) continue;
                    this.placeBlock(world, chunkPos, buildPos, blockState, EnumFacing.DOWN, random);
                }
            }
        }
    }

    public void buildEntrances(World world, ChunkPos chunkPos, Random random) {
        this.parentConnector.buildEntrance(world, chunkPos, random);
    }

    public void buildStairs(World world, ChunkPos chunkPos, Random random) {
        BlockPos startPos = this.getRoomBoundsMin();
        BlockPos stopPos = this.getRoomBoundsMax();
        Vec3i size = this.getRoomSize();
        int centerX = startPos.func_177958_n() + Math.round((float)size.func_177958_n() / 2.0f);
        int centerZ = startPos.func_177952_p() + Math.round((float)size.func_177952_p() / 2.0f);
        int stairsHeight = this.parentConnector.parentSector.getOccupiedSize().func_177956_o() - 1;
        if (this.dungeonSector.type.equalsIgnoreCase("stairs")) {
            stairsHeight = size.func_177956_o() * 2;
        }
        int startX = centerX - 1;
        int stopX = centerX + 1;
        int startY = Math.min(startPos.func_177956_o(), stopPos.func_177956_o());
        int stopY = Math.max(1, startPos.func_177956_o() - stairsHeight);
        int startZ = centerZ - 1;
        int stopZ = centerZ + 1;
        IBlockState floorBlockState = this.theme.getFloor(this, 'B', random);
        IBlockState stairsBlockState = this.stairBlock;
        for (int y = startY; y >= stopY; --y) {
            for (int x = startX; x <= stopX; ++x) {
                for (int z = startZ; z <= stopZ; ++z) {
                    IBlockState blockState = Blocks.field_150350_a.func_176223_P();
                    if (x == centerX && z == centerZ) {
                        blockState = this.theme.getWall(this, 'B', random);
                    }
                    int step = y % 8;
                    int offsetX = x - startX;
                    int offsetZ = z - startZ;
                    if (step % 4 == 3) {
                        if (offsetX == 0 && offsetZ == 0) {
                            blockState = floorBlockState;
                        } else if (offsetX == 0 && offsetZ == 1) {
                            blockState = stairsBlockState;
                        }
                    }
                    if (step % 4 == 2) {
                        if (offsetX == 0 && offsetZ == 2) {
                            blockState = floorBlockState;
                        } else if (offsetX == 1 && offsetZ == 2) {
                            blockState = stairsBlockState.func_185907_a(Rotation.COUNTERCLOCKWISE_90);
                        }
                    }
                    if (step % 4 == 1) {
                        if (offsetX == 2 && offsetZ == 2) {
                            blockState = floorBlockState;
                        } else if (offsetX == 2 && offsetZ == 1) {
                            blockState = stairsBlockState.func_185907_a(Rotation.CLOCKWISE_180);
                        }
                    }
                    if (step % 4 == 0) {
                        if (offsetX == 2 && offsetZ == 0) {
                            blockState = floorBlockState;
                        } else if (offsetX == 1 && offsetZ == 0) {
                            blockState = stairsBlockState.func_185907_a(Rotation.CLOCKWISE_90);
                        }
                    }
                    BlockPos buildPos = new BlockPos(x, y, z);
                    this.placeBlock(world, chunkPos, buildPos, blockState, EnumFacing.UP, random);
                }
            }
        }
    }

    public void spawnMob(World world, ChunkPos chunkPos, BlockPos blockPos, MobSpawn mobSpawn, Random random) {
        int chunkOffset = 8;
        if (blockPos.func_177958_n() < chunkPos.func_180334_c() + chunkOffset || blockPos.func_177958_n() > chunkPos.func_180332_e() + chunkOffset) {
            return;
        }
        if (blockPos.func_177956_o() <= 0 || blockPos.func_177956_o() >= world.func_72800_K()) {
            return;
        }
        if (blockPos.func_177952_p() < chunkPos.func_180333_d() + chunkOffset || blockPos.func_177952_p() > chunkPos.func_180330_f() + chunkOffset) {
            return;
        }
        LycanitesMobs.logDebug("Dungeon", "Spawning mob " + mobSpawn + " at: " + blockPos + " level: " + this.parentConnector.level);
        EntityLiving entityLiving = mobSpawn.createEntity(world);
        entityLiving.func_70107_b((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
        if (entityLiving instanceof BaseCreatureEntity) {
            BaseCreatureEntity entityCreature = (BaseCreatureEntity)entityLiving;
            entityCreature.setHome(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), Math.max(3, Math.max(this.roomSize.func_177958_n(), this.roomSize.func_177952_p())));
        }
        mobSpawn.onSpawned(entityLiving, null);
        world.func_72838_d((Entity)entityLiving);
    }

    public String toString() {
        String bounds = "";
        String size = "";
        if (this.parentConnector != null) {
            bounds = " Bounds: " + this.getOccupiedBoundsMin() + " to " + this.getOccupiedBoundsMax();
            size = " Occupies: " + this.getOccupiedSize();
        }
        return "Sector Instance Type: " + (this.dungeonSector == null ? "Unset" : this.dungeonSector.type) + " Parent Connector Pos: " + (this.parentConnector == null ? "Unset" : this.parentConnector.position) + size + bounds;
    }
}

