/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityKrake
extends AgeableCreatureEntity
implements IMob {
    public EntityKrake(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.1;
        this.canGrow = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextDistractionGoalIndex++, (EntityAIBase)new TemptGoal(this).setIncludeDiet(true));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(false).setRange(1.0));
    }

    @Override
    public boolean func_70685_l(Entity target) {
        if (target == this.func_70643_av() && this.func_142015_aE() + 60 > this.field_70173_aa) {
            return true;
        }
        if (target instanceof EntityPlayer || target instanceof EntityVillager) {
            return target.func_70051_ag();
        }
        return true;
    }

    @Override
    public float getAISpeedModifier() {
        if (this.func_70090_H()) {
            return 1.5f;
        }
        if (this.waterContact()) {
            return 1.25f;
        }
        return super.getAISpeedModifier();
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState blockState = this.func_130014_f_().func_180495_p(pos);
        if (blockState.func_177230_c() == Blocks.field_150355_j) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_130014_f_().func_72896_J() && this.func_130014_f_().func_175710_j(pos)) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public boolean func_184652_a(EntityPlayer player) {
        if (!this.hasAttackTarget()) {
            return true;
        }
        return super.func_184652_a(player);
    }

    @Override
    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        BlockPos groundPos = wanderPosition.func_177977_b();
        while (groundPos.func_177956_o() > 0 && !this.func_130014_f_().func_180495_p(groundPos).func_185904_a().func_76220_a()) {
            groundPos = groundPos.func_177977_b();
        }
        return groundPos.func_177984_a();
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }
}

