/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityVapula
extends TameableCreatureEntity
implements IMob {
    public int blockBreakRadius = 0;
    public float fireDamageAbsorbed = 0.0f;

    public EntityVapula(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.attackPhaseMax = (byte)8;
        this.setAttackCooldownMax(60);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(false).setMaxChaseDistanceSq(3.0f));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackRangedGoal(this).setSpeed(0.75).setRange(18.0f).setMinChaseDistance(10.0f).setCheckSight(false));
    }

    @Override
    public void loadCreatureFlags() {
        this.blockBreakRadius = this.creatureInfo.getFlag("blockBreakRadius", this.blockBreakRadius);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.isRareVariant() && !this.isPetType("familiar") && this.hasAttackTarget() && this.func_70032_d((Entity)this.func_70638_az()) > 1.0f && this.func_70681_au().nextInt(20) == 0) {
            if (this.field_70163_u - 1.0 > this.func_70638_az().field_70163_u) {
                this.leap(6.0f, -1.0, (Entity)this.func_70638_az());
            } else if (this.field_70163_u + 1.0 < this.func_70638_az().field_70163_u) {
                this.leap(6.0f, 1.0, (Entity)this.func_70638_az());
            } else {
                this.leap(6.0f, 0.0, (Entity)this.func_70638_az());
            }
            if (this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") && this.blockBreakRadius > -1 && !this.isTamed()) {
                this.destroyArea((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 10.0f, true, this.blockBreakRadius);
            }
        }
        if (this.func_130014_f_().field_72995_K && !CreatureManager.getInstance().config.disableBlockParticles) {
            for (int i = 0; i < 2; ++i) {
                int[] nArray = new int[1];
                nArray[0] = BlockTallGrass.func_176210_f((IBlockState)Blocks.field_150484_ah.func_176223_P());
                this.func_130014_f_().func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, nArray);
            }
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.hasAttackTarget() && this.func_70638_az() instanceof EntitySilverfish) {
            return 4.0f;
        }
        return super.getAISpeedModifier();
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof EntitySilverfish) {
            target.func_70106_y();
        }
        return true;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile("crystalshard", target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 0.6f, 2.0f, 1.0f);
        this.nextAttackPhase();
        super.attackRanged(target, range);
    }

    @Override
    public int getRangedCooldown() {
        if (this.getAttackPhase() < 7) {
            return super.getRangedCooldown() / 24;
        }
        return super.getRangedCooldown();
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76346_g() != null) {
            EntityLivingBase entityLiving;
            ItemStack heldItem = ItemStack.field_190927_a;
            if (damageSrc.func_76346_g() instanceof EntityLivingBase && !(entityLiving = (EntityLivingBase)damageSrc.func_76346_g()).func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
                heldItem = entityLiving.func_184586_b(EnumHand.MAIN_HAND);
            }
            if (ObjectLists.isPickaxe(heldItem)) {
                return 3.0f;
            }
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("cactus") || type.equals("inWall")) {
            return false;
        }
        if (source.func_76347_k()) {
            this.fireDamageAbsorbed += damage;
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }
}

