/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.info.altar.AltarInfoAmalgalich;
import com.lycanitesmobs.core.info.altar.AltarInfoAsmodeus;
import com.lycanitesmobs.core.info.altar.AltarInfoCelestialGeonach;
import com.lycanitesmobs.core.info.altar.AltarInfoCrimsonEpion;
import com.lycanitesmobs.core.info.altar.AltarInfoEbonCacodemon;
import com.lycanitesmobs.core.info.altar.AltarInfoLunarGrue;
import com.lycanitesmobs.core.info.altar.AltarInfoMottleAbaia;
import com.lycanitesmobs.core.info.altar.AltarInfoPhosphorescentChupacabra;
import com.lycanitesmobs.core.info.altar.AltarInfoRahovart;
import com.lycanitesmobs.core.info.altar.AltarInfoRoyalArchvile;
import com.lycanitesmobs.core.info.altar.AltarInfoUmberLobber;
import com.lycanitesmobs.core.mobevent.effects.StructureBuilder;
import com.lycanitesmobs.core.mobevent.trigger.AltarMobEventTrigger;
import com.lycanitesmobs.core.worldgen.mobevents.AmalgalichStructureBuilder;
import com.lycanitesmobs.core.worldgen.mobevents.AsmodeusStructureBuilder;
import com.lycanitesmobs.core.worldgen.mobevents.RahovartStructureBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AltarInfo {
    public static boolean altarsEnabled = true;
    public static boolean checkDimensions = false;
    public static Map<String, Double> rareSubspeciesMutlipliers = new HashMap<String, Double>();
    public static Map<String, AltarInfo> altars = new HashMap<String, AltarInfo>();
    public String name = "Altar";
    public AltarMobEventTrigger mobEventTrigger;

    public static void loadGlobalSettings() {
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.modInfo, "general");
        config.setCategoryComment("Altars", "Altars are block arrangements that can be activated using Soulkeys to summon rare subspecies as mini bosses or trigger events including boss events.");
        altarsEnabled = config.getBool("Altars", "Altars Enabled", altarsEnabled, "Set to false to disable altars, Soulkeys can still be crafted but wont work on Altars.");
        checkDimensions = config.getBool("Altars", "Check Dimension", checkDimensions, "If set to true, Altars will only activate in dimensions that the monster spawned or event started is allowed in.");
        String[] statNames = new String[]{"Health", "Defense", "Speed", "Damage", "Haste", "Effect", "Pierce"};
        rareSubspeciesMutlipliers = new HashMap<String, Double>();
        for (String statName : statNames) {
            double defaultValue = 4.0;
            if ("Health".equalsIgnoreCase(statName)) {
                defaultValue = 10.0;
            }
            if ("Speed".equalsIgnoreCase(statName)) {
                defaultValue = 1.5;
            }
            rareSubspeciesMutlipliers.put(statName.toUpperCase(), config.getDouble("Altars", statName + " Altar Stat Multiplier", defaultValue));
        }
    }

    public static boolean checkAltarsEnabled() {
        if (altars.size() < 1) {
            return false;
        }
        return altarsEnabled;
    }

    public static void addAltar(AltarInfo altarInfo) {
        altars.put(altarInfo.name.toLowerCase(), altarInfo);
    }

    public static AltarInfo getAltar(String name) {
        if (altars.containsKey(name.toLowerCase())) {
            return altars.get(name.toLowerCase());
        }
        return null;
    }

    public static void createAltars() {
        AltarInfoEbonCacodemon ebonCacodemonAltar = new AltarInfoEbonCacodemon("EbonCacodemonAltar");
        AltarInfo.addAltar(ebonCacodemonAltar);
        AltarInfoRahovart rahovartAltar = new AltarInfoRahovart("RahovartAltar");
        AltarInfo.addAltar(rahovartAltar);
        StructureBuilder.addStructureBuilder(new RahovartStructureBuilder());
        AltarInfoAsmodeus asmodeusAltar = new AltarInfoAsmodeus("AsmodeusAltar");
        AltarInfo.addAltar(asmodeusAltar);
        StructureBuilder.addStructureBuilder(new AsmodeusStructureBuilder());
        AltarInfoAmalgalich amalgalichAltar = new AltarInfoAmalgalich("AmalgalichAltar");
        AltarInfo.addAltar(amalgalichAltar);
        StructureBuilder.addStructureBuilder(new AmalgalichStructureBuilder());
        AltarInfoUmberLobber umberLobberAltar = new AltarInfoUmberLobber("UmberLobberAltar");
        AltarInfo.addAltar(umberLobberAltar);
        AltarInfoCelestialGeonach celestialGeonachAltar = new AltarInfoCelestialGeonach("CelestialGeonachAltar");
        AltarInfo.addAltar(celestialGeonachAltar);
        AltarInfoLunarGrue lunarGrueAltar = new AltarInfoLunarGrue("LunarGrueAltar");
        AltarInfo.addAltar(lunarGrueAltar);
        AltarInfoMottleAbaia mottledAbaiaAltar = new AltarInfoMottleAbaia("MottledAbaia");
        AltarInfo.addAltar(mottledAbaiaAltar);
        AltarInfoCrimsonEpion crimsonEpionAltar = new AltarInfoCrimsonEpion("CrimsonEpion");
        AltarInfo.addAltar(crimsonEpionAltar);
        AltarInfoRoyalArchvile royalArchvileAltar = new AltarInfoRoyalArchvile("RoyalArchvile");
        AltarInfo.addAltar(royalArchvileAltar);
        AltarInfoPhosphorescentChupacabra phosphorescentChupacabraAltar = new AltarInfoPhosphorescentChupacabra("PhosphorescentChupacabra");
        AltarInfo.addAltar(phosphorescentChupacabraAltar);
    }

    public AltarInfo(String name) {
        this.name = name;
    }

    public boolean checkBlockEvent(Entity entity, World world, BlockPos pos) {
        return true;
    }

    public boolean quickCheck(Entity entity, World world, BlockPos pos) {
        return false;
    }

    public boolean fullCheck(Entity entity, World world, BlockPos pos) {
        return false;
    }

    public boolean activate(Entity entity, World world, BlockPos pos, int variant) {
        if (this.mobEventTrigger == null) {
            return false;
        }
        return this.mobEventTrigger.onActivate(entity, world, pos, variant);
    }

    public BlockPos getFacingPosition(BlockPos pos, double distance, double angle) {
        double xAmount = -Math.sin(Math.toRadians(angle));
        double zAmount = Math.cos(Math.toRadians(angle));
        BlockPos facingPos = new BlockPos((double)Math.round((double)pos.func_177958_n() + distance * xAmount), (double)pos.func_177956_o(), (double)Math.round((double)pos.func_177952_p() + distance * zAmount));
        return facingPos;
    }
}

