/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.BlockMaker;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.block.BlockEquipmentForge;
import com.lycanitesmobs.core.block.BlockFluidBase;
import com.lycanitesmobs.core.block.BlockSoulcube;
import com.lycanitesmobs.core.block.BlockSummoningPedestal;
import com.lycanitesmobs.core.block.EquipmentInfuserBlock;
import com.lycanitesmobs.core.block.building.BlockPropolis;
import com.lycanitesmobs.core.block.building.BlockVeswax;
import com.lycanitesmobs.core.block.effect.BlockDoomfire;
import com.lycanitesmobs.core.block.effect.BlockFrostCloud;
import com.lycanitesmobs.core.block.effect.BlockFrostfire;
import com.lycanitesmobs.core.block.effect.BlockFrostweb;
import com.lycanitesmobs.core.block.effect.BlockHellfire;
import com.lycanitesmobs.core.block.effect.BlockIcefire;
import com.lycanitesmobs.core.block.effect.BlockPoisonCloud;
import com.lycanitesmobs.core.block.effect.BlockPoopCloud;
import com.lycanitesmobs.core.block.effect.BlockQuickWeb;
import com.lycanitesmobs.core.block.effect.BlockScorchfire;
import com.lycanitesmobs.core.block.effect.BlockShadowfire;
import com.lycanitesmobs.core.block.fluid.BlockFluidAcid;
import com.lycanitesmobs.core.block.fluid.BlockFluidMoglava;
import com.lycanitesmobs.core.block.fluid.BlockFluidOoze;
import com.lycanitesmobs.core.block.fluid.BlockFluidPoison;
import com.lycanitesmobs.core.block.fluid.BlockFluidRabbitooze;
import com.lycanitesmobs.core.block.fluid.BlockFluidSharacid;
import com.lycanitesmobs.core.block.fluid.BlockFluidVesspoison;
import com.lycanitesmobs.core.info.ItemConfig;
import com.lycanitesmobs.core.info.ItemInfo;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.item.GenericBucketItem;
import com.lycanitesmobs.core.item.ItemMobToken;
import com.lycanitesmobs.core.item.consumable.ItemCleansingCrystal;
import com.lycanitesmobs.core.item.consumable.ItemHalloweenTreat;
import com.lycanitesmobs.core.item.consumable.ItemImmunizer;
import com.lycanitesmobs.core.item.consumable.ItemWinterGift;
import com.lycanitesmobs.core.item.consumable.ItemWinterGiftLarge;
import com.lycanitesmobs.core.item.equipment.ItemEquipment;
import com.lycanitesmobs.core.item.special.ItemFrostyFur;
import com.lycanitesmobs.core.item.special.ItemGeistLiver;
import com.lycanitesmobs.core.item.special.ItemPoisonGland;
import com.lycanitesmobs.core.item.special.ItemSoulgazer;
import com.lycanitesmobs.core.item.special.ItemSoulkey;
import com.lycanitesmobs.core.item.special.ItemSoulstone;
import com.lycanitesmobs.core.item.special.ItemWraithSigil;
import com.lycanitesmobs.core.item.temp.ItemScepterAquaPulse;
import com.lycanitesmobs.core.item.temp.ItemScepterArcaneLaserStorm;
import com.lycanitesmobs.core.item.temp.ItemScepterBlizzard;
import com.lycanitesmobs.core.item.temp.ItemScepterBloodleech;
import com.lycanitesmobs.core.item.temp.ItemScepterBoulderBlast;
import com.lycanitesmobs.core.item.temp.ItemScepterDemonicLightning;
import com.lycanitesmobs.core.item.temp.ItemScepterDoomfire;
import com.lycanitesmobs.core.item.temp.ItemScepterFrostbolt;
import com.lycanitesmobs.core.item.temp.ItemScepterFrostweb;
import com.lycanitesmobs.core.item.temp.ItemScepterHellfire;
import com.lycanitesmobs.core.item.temp.ItemScepterIcefire;
import com.lycanitesmobs.core.item.temp.ItemScepterLifeDrain;
import com.lycanitesmobs.core.item.temp.ItemScepterMagma;
import com.lycanitesmobs.core.item.temp.ItemScepterMudshot;
import com.lycanitesmobs.core.item.temp.ItemScepterPoisonRay;
import com.lycanitesmobs.core.item.temp.ItemScepterPoop;
import com.lycanitesmobs.core.item.temp.ItemScepterQuill;
import com.lycanitesmobs.core.item.temp.ItemScepterScorchfire;
import com.lycanitesmobs.core.item.temp.ItemScepterSpectralbolt;
import com.lycanitesmobs.core.item.temp.ItemScepterTundra;
import com.lycanitesmobs.core.item.temp.ItemScepterWaterJet;
import com.lycanitesmobs.core.item.temp.ItemStaffBlood;
import com.lycanitesmobs.core.item.temp.ItemStaffSavage;
import com.lycanitesmobs.core.item.temp.ItemStaffStable;
import com.lycanitesmobs.core.item.temp.ItemStaffSturdy;
import com.lycanitesmobs.core.item.temp.ItemStaffSummoning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class ItemManager
extends JSONLoader {
    public static ItemManager INSTANCE;
    public Map<String, ItemInfo> items = new HashMap<String, ItemInfo>();
    public List<ModInfo> loadedGroups = new ArrayList<ModInfo>();
    public ItemConfig config;

    public static ItemManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ItemManager();
        }
        return INSTANCE;
    }

    public void startup(ModInfo modInfo) {
        this.loadConfig();
        this.loadAllFromJson(modInfo);
        for (ItemInfo itemInfo : this.items.values()) {
            String cookedName;
            if (!itemInfo.name.contains("raw_") || !this.items.containsKey(cookedName = itemInfo.name.replace("raw_", "cooked_"))) continue;
            GameRegistry.addSmelting((Item)itemInfo.item, (ItemStack)new ItemStack(this.items.get((Object)cookedName).item, 1), (float)0.5f);
        }
        this.loadItems();
    }

    public void loadAllFromJson(ModInfo modInfo) {
        if (!this.loadedGroups.contains(modInfo)) {
            this.loadedGroups.add(modInfo);
        }
        this.loadAllJson(modInfo, "Items", "items", "name", true);
        LycanitesMobs.logDebug("Items", "Complete! " + this.items.size() + " JSON Items Loaded In Total.");
    }

    @Override
    public void parseJson(ModInfo modInfo, String loadGroup, JsonObject json) {
        ItemInfo itemInfo = new ItemInfo(modInfo);
        itemInfo.loadFromJSON(json);
        this.items.put(itemInfo.name, itemInfo);
        ObjectManager.addItem(itemInfo.name, itemInfo.getItem());
    }

    public void loadConfig() {
        ItemConfig.loadGlobalSettings();
    }

    public void loadItems() {
        ModInfo group = LycanitesMobs.modInfo;
        ObjectManager.addItem("soulgazer", new ItemSoulgazer());
        ObjectManager.addItem("soulstone", new ItemSoulstone(group));
        ObjectManager.addItem("equipment", new ItemEquipment());
        ObjectManager.addItem("mobtoken", new ItemMobToken(group));
        ObjectManager.addItem("soulkey", new ItemSoulkey("soulkey", 0));
        ObjectManager.addItem("soulkeydiamond", new ItemSoulkey("soulkeydiamond", 1));
        ObjectManager.addItem("soulkeyemerald", new ItemSoulkey("soulkeyemerald", 2));
        ObjectManager.addBlock("summoningpedestal", new BlockSummoningPedestal(group));
        ObjectManager.addBlock("equipmentforge_lesser", new BlockEquipmentForge(group, 1));
        ObjectManager.addBlock("equipmentforge_greater", new BlockEquipmentForge(group, 2));
        ObjectManager.addBlock("equipmentforge_master", new BlockEquipmentForge(group, 3));
        ObjectManager.addBlock("equipment_infuser", new EquipmentInfuserBlock(group));
        ObjectManager.addItem("immunizer", new ItemImmunizer());
        ObjectManager.addItem("cleansingcrystal", new ItemCleansingCrystal());
        ObjectManager.addItem("halloweentreat", new ItemHalloweenTreat());
        ObjectManager.addItem("wintergift", new ItemWinterGift());
        ObjectManager.addItem("wintergiftlarge", new ItemWinterGiftLarge());
        ObjectManager.addItem("frostyfur", new ItemFrostyFur());
        ObjectManager.addItem("poisongland", new ItemPoisonGland());
        ObjectManager.addItem("geistliver", new ItemGeistLiver());
        ObjectLists.addItem("diet_detritivore", ObjectManager.getItem("geistliver"));
        ObjectManager.addItem("wraithsigil", new ItemWraithSigil());
        Fluid fluid = ObjectManager.addFluid("ooze");
        this.addFluid("ooze", fluid, new BlockFluidOoze(fluid, "ooze"), 10, 3000, 5000, 0, true, true);
        fluid = ObjectManager.addFluid("rabbitooze");
        this.addFluid("rabbitooze", fluid, new BlockFluidRabbitooze(fluid, "rabbitooze"), 10, 3000, 5000, 0, true, true);
        fluid = ObjectManager.addFluid("moglava");
        this.addFluid("moglava", fluid, new BlockFluidMoglava(fluid), 15, 3000, 5000, 1100, false, false);
        fluid = ObjectManager.addFluid("acid");
        this.addFluid("acid", fluid, new BlockFluidAcid(fluid, "acid"), 10, 1000, 10, 40, false, true);
        fluid = ObjectManager.addFluid("sharacid");
        this.addFluid("sharacid", fluid, new BlockFluidSharacid(fluid, "sharacid"), 10, 1000, 10, 40, false, true);
        fluid = ObjectManager.addFluid("poison");
        this.addFluid("poison", fluid, new BlockFluidPoison(fluid, "poison"), 0, 1000, 8, 20, false, true);
        fluid = ObjectManager.addFluid("vesspoison");
        this.addFluid("vesspoison", fluid, new BlockFluidVesspoison(fluid, "vesspoison"), 0, 1000, 8, 20, false, true);
        ObjectManager.addItem("frostwebscepter", new ItemScepterFrostweb(), 2, 1, 1);
        ObjectManager.addItem("tundrascepter", new ItemScepterTundra(), 2, 1, 1);
        ObjectManager.addItem("icefirescepter", new ItemScepterIcefire(), 2, 1, 1);
        ObjectManager.addItem("blizzardscepter", new ItemScepterBlizzard(), 2, 1, 1);
        ObjectManager.addItem("doomfirescepter", new ItemScepterDoomfire(), 2, 1, 1);
        ObjectManager.addItem("hellfirescepter", new ItemScepterHellfire(), 2, 1, 1);
        ObjectManager.addItem("demoniclightningscepter", new ItemScepterDemonicLightning(), 2, 1, 1);
        ObjectManager.addItem("mudshotscepter", new ItemScepterMudshot(), 2, 1, 1);
        ObjectManager.addItem("aquapulsescepter", new ItemScepterAquaPulse(), 2, 1, 1);
        ObjectManager.addItem("lifedrainscepter", new ItemScepterLifeDrain(), 2, 1, 1);
        ObjectManager.addItem("frostboltscepter", new ItemScepterFrostbolt(), 2, 1, 1);
        ObjectManager.addItem("waterjetscepter", new ItemScepterWaterJet(), 2, 1, 1);
        ObjectManager.addItem("magmascepter", new ItemScepterMagma(), 2, 1, 1);
        ObjectManager.addItem("scorchfirescepter", new ItemScepterScorchfire(), 2, 1, 1);
        ObjectManager.addItem("poopscepter", new ItemScepterPoop(), 2, 1, 1);
        ObjectManager.addItem("boulderblastscepter", new ItemScepterBoulderBlast(), 2, 1, 1);
        ObjectManager.addItem("arcanelaserstormscepter", new ItemScepterArcaneLaserStorm(), 2, 1, 1);
        ObjectManager.addItem("quillscepter", new ItemScepterQuill(), 2, 1, 1);
        ObjectManager.addItem("spectralboltscepter", new ItemScepterSpectralbolt(), 2, 1, 1);
        ObjectManager.addItem("bloodleechscepter", new ItemScepterBloodleech(), 2, 1, 1);
        ObjectManager.addItem("poisonrayscepter", new ItemScepterPoisonRay(), 2, 1, 1);
        ObjectManager.addItem("summoningstaff", new ItemStaffSummoning("summoningstaff", "summoningstaff"));
        ObjectManager.addItem("stablesummoningstaff", new ItemStaffStable("stablesummoningstaff", "staffstable"));
        ObjectManager.addItem("bloodsummoningstaff", new ItemStaffBlood("bloodsummoningstaff", "staffblood"));
        ObjectManager.addItem("sturdysummoningstaff", new ItemStaffSturdy("sturdysummoningstaff", "staffsturdy"));
        ObjectManager.addItem("savagesummoningstaff", new ItemStaffSavage("savagesummoningstaff", "staffsavage"));
        ObjectManager.addBlock("frostweb", new BlockFrostweb());
        BlockMaker.addStoneBlocks(group, "lush");
        BlockMaker.addStoneBlocks(group, "desert");
        BlockMaker.addStoneBlocks(group, "shadow");
        BlockMaker.addStoneBlocks(group, "demon");
        BlockMaker.addStoneBlocks(group, "aberrant");
        ObjectManager.addBlock("soulcubedemonic", new BlockSoulcube(group, "soulcubedemonic"));
        ObjectManager.addBlock("soulcubeundead", new BlockSoulcube(group, "soulcubeundead"));
        ObjectManager.addBlock("soulcubeaberrant", new BlockSoulcube(group, "soulcubeaberrant"));
        ObjectManager.addBlock("propolis", new BlockPropolis());
        GameRegistry.addSmelting((Block)ObjectManager.getBlock("propolis"), (ItemStack)new ItemStack(Blocks.field_150405_ch, 1), (float)0.5f);
        ObjectManager.addBlock("veswax", new BlockVeswax());
        GameRegistry.addSmelting((Block)ObjectManager.getBlock("veswax"), (ItemStack)new ItemStack(Items.field_151102_aT, 6), (float)0.5f);
        AssetManager.addSound("frostcloud", group, "block.frostcloud");
        ObjectManager.addBlock("frostcloud", new BlockFrostCloud());
        AssetManager.addSound("frostfire", group, "block.frostfire");
        ObjectManager.addBlock("frostfire", new BlockFrostfire());
        AssetManager.addSound("icefire", group, "block.icefire");
        ObjectManager.addBlock("icefire", new BlockIcefire());
        AssetManager.addSound("hellfire", group, "block.hellfire");
        ObjectManager.addBlock("hellfire", new BlockHellfire());
        AssetManager.addSound("doomfire", group, "block.doomfire");
        ObjectManager.addBlock("doomfire", new BlockDoomfire());
        AssetManager.addSound("scorchfire", group, "block.scorchfire");
        ObjectManager.addBlock("scorchfire", new BlockScorchfire());
        AssetManager.addSound("shadowfire", group, "block.shadowfire");
        ObjectManager.addBlock("shadowfire", new BlockShadowfire());
        AssetManager.addSound("poisoncloud", group, "block.poisoncloud");
        ObjectManager.addBlock("poisoncloud", new BlockPoisonCloud());
        AssetManager.addSound("poopcloud", group, "block.poopcloud");
        ObjectManager.addBlock("poopcloud", new BlockPoopCloud());
        ObjectManager.addBlock("quickweb", new BlockQuickWeb());
    }

    public void addFluid(String name, Fluid fluid, BlockFluidBase block, int luminosity, int density, int viscosity, int temperature, boolean addSound, boolean addDamageSource) {
        fluid.setLuminosity(luminosity).setDensity(density).setViscosity(viscosity).setTemperature(temperature);
        ObjectManager.addBlock(name, (Block)block);
        ObjectManager.addItem("bucket" + name, new GenericBucketItem(fluid, (Block)block, name).func_77642_a(Items.field_151133_ar));
        if (addSound) {
            AssetManager.addSound(name, LycanitesMobs.modInfo, "block." + name);
        }
        if (addDamageSource) {
            ObjectManager.addDamageSource(name, new DamageSource(name));
        }
    }

    public void registerItemOres() {
        OreDictionary.registerOre((String)"listAllporkraw", (Item)Items.field_151147_al);
        OreDictionary.registerOre((String)"listAllporkcooked", (Item)Items.field_151157_am);
        OreDictionary.registerOre((String)"listAllbeefraw", (Item)Items.field_151082_bd);
        OreDictionary.registerOre((String)"listAllbeefcooked", (Item)Items.field_151083_be);
        OreDictionary.registerOre((String)"listAllchickenraw", (Item)Items.field_151076_bf);
        OreDictionary.registerOre((String)"listAllchickencooked", (Item)Items.field_151077_bg);
        OreDictionary.registerOre((String)"listAllmuttonraw", (Item)Items.field_179561_bm);
        OreDictionary.registerOre((String)"listAllmuttoncooked", (Item)Items.field_179557_bn);
        OreDictionary.registerOre((String)"listAllrabbitraw", (Item)Items.field_179558_bo);
        OreDictionary.registerOre((String)"listAllrabbitcooked", (Item)Items.field_179559_bp);
        OreDictionary.registerOre((String)"listAllfishraw", (Item)Items.field_151115_aP);
        OreDictionary.registerOre((String)"listAllfishcooked", (Item)Items.field_179566_aV);
        OreDictionary.registerOre((String)"listAllVegetables", (Item)Items.field_151015_O);
        OreDictionary.registerOre((String)"listAllVegetables", (Item)Items.field_151025_P);
        OreDictionary.registerOre((String)"listAllVegetables", (Item)Items.field_151172_bF);
        OreDictionary.registerOre((String)"listAllVegetables", (Item)Items.field_151174_bG);
        OreDictionary.registerOre((String)"listAllVegetables", (Item)Items.field_151168_bH);
        OreDictionary.registerOre((String)"listAllVegetables", (Item)Items.field_185164_cV);
        OreDictionary.registerOre((String)"listAllVegetables", (Item)Items.field_151009_A);
        OreDictionary.registerOre((String)"listAllFruit", (Item)Items.field_151034_e);
        OreDictionary.registerOre((String)"listAllFruit", (Item)Items.field_151127_ba);
        OreDictionary.registerOre((String)"listAllSweet", (Item)Items.field_151105_aU);
        OreDictionary.registerOre((String)"listAllSweet", (Item)Items.field_151158_bO);
        OreDictionary.registerOre((String)"listAllSweet", (Item)Items.field_151106_aX);
        OreDictionary.registerOre((String)"listAllSweet", (Item)Items.field_151102_aT);
        OreDictionary.registerOre((String)"listAllEntomo", (Item)Items.field_151070_bp);
        OreDictionary.registerOre((String)"listAllEntomo", (Item)Items.field_151071_bq);
        OreDictionary.registerOre((String)"listAllRotten", (Item)Items.field_151078_bh);
        OreDictionary.registerOre((String)"listAllporkraw", (Item)ObjectManager.getItem("raw_yeti_meat"));
        OreDictionary.registerOre((String)"listAllporkcooked", (Item)ObjectManager.getItem("cooked_yeti_meat"));
        OreDictionary.registerOre((String)"listAllbeefraw", (Item)ObjectManager.getItem("raw_pinky_meat"));
        OreDictionary.registerOre((String)"listAllbeefcooked", (Item)ObjectManager.getItem("cooked_pinky_meat"));
        OreDictionary.registerOre((String)"listAllchickenraw", (Item)ObjectManager.getItem("raw_joust_meat"));
        OreDictionary.registerOre((String)"listAllchickencooked", (Item)ObjectManager.getItem("cooked_joust_meat"));
        OreDictionary.registerOre((String)"listAllfishraw", (Item)ObjectManager.getItem("raw_silex_meat"));
        OreDictionary.registerOre((String)"listAllfishcooked", (Item)ObjectManager.getItem("cooked_silex_meat"));
        OreDictionary.registerOre((String)"listAllrabbitraw", (Item)ObjectManager.getItem("raw_krake_meat"));
        OreDictionary.registerOre((String)"listAllrabbitcooked", (Item)ObjectManager.getItem("cooked_krake_meat"));
        OreDictionary.registerOre((String)"listAllfishcooked", (Item)ObjectManager.getItem("cooked_cephignis_meat"));
        OreDictionary.registerOre((String)"listAllchickenraw", (Item)ObjectManager.getItem("raw_concapede_meat"));
        OreDictionary.registerOre((String)"listAllchickencooked", (Item)ObjectManager.getItem("cooked_concapede_meat"));
        OreDictionary.registerOre((String)"listAllEntomoraw", (Item)ObjectManager.getItem("raw_concapede_meat"));
        OreDictionary.registerOre((String)"listAllEntomocooked", (Item)ObjectManager.getItem("cooked_concapede_meat"));
        OreDictionary.registerOre((String)"listAllmuttonraw", (Item)ObjectManager.getItem("raw_yale_meat"));
        OreDictionary.registerOre((String)"listAllmuttoncooked", (Item)ObjectManager.getItem("cooked_yale_meat"));
        OreDictionary.registerOre((String)"listAllporkraw", (Item)ObjectManager.getItem("raw_maka_meat"));
        OreDictionary.registerOre((String)"listAllporkcooked", (Item)ObjectManager.getItem("cooked_maka_meat"));
        OreDictionary.registerOre((String)"listAllfishraw", (Item)ObjectManager.getItem("raw_ika_meat"));
        OreDictionary.registerOre((String)"listAllfishcooked", (Item)ObjectManager.getItem("cooked_ika_meat"));
        OreDictionary.registerOre((String)"listAllmuttonraw", (Item)ObjectManager.getItem("raw_chupacabra_meat"));
        OreDictionary.registerOre((String)"listAllmuttoncooked", (Item)ObjectManager.getItem("cooked_chupacabra_meat"));
        OreDictionary.registerOre((String)"listAllbeefraw", (Item)ObjectManager.getItem("raw_aspid_meat"));
        OreDictionary.registerOre((String)"listAllbeefcooked", (Item)ObjectManager.getItem("cooked_aspid_meat"));
        OreDictionary.registerOre((String)"listAllRotten", (Item)ObjectManager.getItem("geistliver"));
    }

    public void registerBlockOres() {
        OreDictionary.registerOre((String)"listAllVegetables", (Block)Blocks.field_150337_Q);
        OreDictionary.registerOre((String)"listAllVegetables", (Block)Blocks.field_150338_P);
        OreDictionary.registerOre((String)"listAllVegetables", (Block)Blocks.field_150423_aK);
    }
}

