/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment;

import com.google.common.collect.Multimap;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.ExtendedEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import com.lycanitesmobs.core.item.equipment.features.DamageEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.EffectEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.HarvestEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.ProjectileEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.SummonEquipmentFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEquipment
extends ItemBase {
    public static ItemStack ITEMSTACK_TO_RENDER;
    public static int PART_LIMIT;

    public ItemEquipment() {
        this.itemName = "equipment";
        this.modInfo = LycanitesMobs.modInfo;
        this.setRegistryName(this.modInfo.modid, this.itemName);
        this.func_77655_b(this.itemName);
        this.func_77625_d(1);
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> tooltip, ITooltipFlag tooltipFlag) {
        super.func_77624_a(itemStack, world, tooltip, tooltipFlag);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        for (String description : this.getAdditionalDescriptions(itemStack, world, tooltipFlag)) {
            List formattedDescriptionList = fontRenderer.func_78271_c(description, DESCRIPTION_WIDTH + 100);
            for (Object formattedDescription : formattedDescriptionList) {
                if (!(formattedDescription instanceof String)) continue;
                tooltip.add("\u00a73" + formattedDescription);
            }
        }
    }

    @Override
    public String getDescription(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        return LanguageManager.translate("item.equipment.description");
    }

    public List<String> getAdditionalDescriptions(ItemStack itemStack, @Nullable World world, ITooltipFlag tooltipFlag) {
        ArrayList<String> descriptions = new ArrayList<String>();
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(itemStack)) {
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null) continue;
            int partLevel = equipmentPart.getLevel(equipmentPartStack);
            descriptions.add(equipmentPart.func_77653_i(itemStack) + " " + LanguageManager.translate("entity.level") + " " + partLevel);
        }
        descriptions.add("-------------------\n");
        String damageDescription = LanguageManager.translate("equipment.feature.damage") + " " + String.format("%.0f", this.getDamageAmount(itemStack) + 1.0);
        damageDescription = damageDescription + "\n" + LanguageManager.translate("equipment.feature.damage.cooldown") + " " + String.format("%.1f", this.getDamageCooldown(itemStack));
        damageDescription = damageDescription + "\n" + LanguageManager.translate("equipment.feature.damage.knockback") + " " + String.format("%.0f", this.getDamageKnockback(itemStack));
        damageDescription = damageDescription + "\n" + LanguageManager.translate("equipment.feature.damage.range") + " " + String.format("%.1f", this.getDamageRange(itemStack));
        damageDescription = damageDescription + "\n" + LanguageManager.translate("equipment.feature.damage.sweep") + " " + String.format("%.0f", Math.min(this.getDamageSweep(itemStack), 360.0));
        descriptions.add(damageDescription);
        String harvestSummaries = this.getFeatureSummaries(itemStack, "harvest");
        String effectSummaries = this.getFeatureSummaries(itemStack, "effect");
        String projectileSummaries = this.getFeatureSummaries(itemStack, "projectile");
        String summonSummaries = this.getFeatureSummaries(itemStack, "summon");
        if (!("".equals(harvestSummaries) && "".equals(effectSummaries) && "".equals(projectileSummaries) && "".equals(summonSummaries))) {
            descriptions.add("-------------------\n");
            if (!"".equals(harvestSummaries)) {
                descriptions.add(LanguageManager.translate("equipment.feature.harvest") + " " + harvestSummaries);
            }
            if (!"".equals(effectSummaries)) {
                descriptions.add(LanguageManager.translate("equipment.feature.effect") + " " + effectSummaries);
            }
            if (!"".equals(projectileSummaries)) {
                descriptions.add(LanguageManager.translate("equipment.feature.projectile") + " " + projectileSummaries);
            }
            if (!"".equals(summonSummaries)) {
                descriptions.add(LanguageManager.translate("equipment.feature.summon") + " " + summonSummaries);
            }
        }
        return descriptions;
    }

    public String getFeatureSummaries(ItemStack itemStack, String featureType) {
        Map<EquipmentFeature, ItemStack> effectFeatures = this.getFeaturesByTypeWithPartStack(itemStack, featureType);
        String featureSummaries = "";
        boolean first = true;
        for (EquipmentFeature equipmentFeature : effectFeatures.keySet()) {
            if (!first) {
                featureSummaries = featureSummaries + ", ";
            }
            first = false;
            String featureSummary = equipmentFeature.getSummary(effectFeatures.get(equipmentFeature), this.getPartLevel(effectFeatures.get(equipmentFeature)));
            if (featureSummary == null) continue;
            featureSummaries = featureSummaries + featureSummary;
        }
        return featureSummaries;
    }

    public int getMetadata(ItemStack stack) {
        ITEMSTACK_TO_RENDER = stack;
        return super.getMetadata(stack);
    }

    public NBTTagCompound getTagCompound(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p();
        }
        return new NBTTagCompound();
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public FontRenderer getFontRenderer(ItemStack stack) {
        return LycanitesMobs.proxy.getFontRenderer();
    }

    public NonNullList<ItemStack> getEquipmentPartStacks(ItemStack itemStack) {
        NonNullList itemStacks = NonNullList.func_191197_a((int)PART_LIMIT, (Object)ItemStack.field_190927_a);
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        if (nbt.func_74764_b("Items")) {
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)itemStacks);
        }
        return itemStacks;
    }

    public int getEquipmentPartCount(ItemStack itemStack) {
        int partCount = 0;
        for (ItemStack partStack : this.getEquipmentPartStacks(itemStack)) {
            if (partStack.func_190926_b()) continue;
            ++partCount;
        }
        return partCount;
    }

    public ItemEquipmentPart getEquipmentPart(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        if (!(itemStack.func_77973_b() instanceof ItemEquipmentPart)) {
            return null;
        }
        return (ItemEquipmentPart)itemStack.func_77973_b();
    }

    public void addEquipmentPart(ItemStack equipmentStack, ItemStack equipmentPartStack, int slotIndex) {
        if (slotIndex >= PART_LIMIT) {
            return;
        }
        NonNullList<ItemStack> itemStacks = this.getEquipmentPartStacks(equipmentStack);
        itemStacks.set(slotIndex, (Object)equipmentPartStack);
        NBTTagCompound nbt = this.getTagCompound(equipmentStack);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, itemStacks);
        equipmentStack.func_77982_d(nbt);
    }

    public List<EquipmentFeature> getFeaturesByType(ItemStack equipmentStack, String featureType) {
        ArrayList<EquipmentFeature> features = new ArrayList<EquipmentFeature>();
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(equipmentStack)) {
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null) continue;
            for (EquipmentFeature feature : equipmentPart.features) {
                if (!feature.isActive(equipmentPartStack, equipmentPart.getLevel(equipmentPartStack)) || !feature.featureType.equalsIgnoreCase(featureType)) continue;
                features.add(feature);
            }
        }
        return features;
    }

    public Map<EquipmentFeature, ItemStack> getFeaturesByTypeWithPartStack(ItemStack equipmentStack, String featureType) {
        HashMap<EquipmentFeature, ItemStack> features = new HashMap<EquipmentFeature, ItemStack>();
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(equipmentStack)) {
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null) continue;
            for (EquipmentFeature feature : equipmentPart.features) {
                if (!feature.isActive(equipmentPartStack, equipmentPart.getLevel(equipmentPartStack)) || !feature.featureType.equalsIgnoreCase(featureType)) continue;
                features.put(feature, equipmentPartStack);
            }
        }
        return features;
    }

    public void applyLevelCap(ItemStack equipmentStack, int levelCap) {
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(equipmentStack)) {
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null) continue;
            equipmentPart.setLevel(equipmentPartStack, Math.min(levelCap, equipmentPart.getLevel(equipmentPartStack)));
        }
    }

    public int getHighestLevel(ItemStack equipmentStack) {
        int highestLevel = 0;
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(equipmentStack)) {
            int partLevel;
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null || (partLevel = equipmentPart.getLevel(equipmentPartStack)) <= highestLevel) continue;
            highestLevel = partLevel;
        }
        return highestLevel;
    }

    public int getPartLevel(ItemStack partStack) {
        Item featureItem = partStack.func_77973_b();
        if (!(featureItem instanceof ItemEquipmentPart)) {
            return 1;
        }
        ItemEquipmentPart featurePart = (ItemEquipmentPart)featureItem;
        return featurePart.getLevel(partStack);
    }

    @Override
    public EnumAction func_77661_b(ItemStack itemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 18000;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        boolean active = false;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "projectile")) {
            ProjectileEquipmentFeature projectileFeature = (ProjectileEquipmentFeature)equipmentFeature;
            if (!projectileFeature.onUseSecondary(world, player, hand)) continue;
            active = true;
        }
        if (active) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
    }

    @Override
    public void onUsingTick(ItemStack itemStack, EntityLivingBase user, int count) {
        if (!user.func_184587_cr()) {
            return;
        }
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "projectile")) {
            ProjectileEquipmentFeature projectileFeature = (ProjectileEquipmentFeature)equipmentFeature;
            projectileFeature.onHoldSecondary(user, count);
        }
    }

    public void onItemLeftClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "projectile")) {
            ProjectileEquipmentFeature projectileFeature = (ProjectileEquipmentFeature)equipmentFeature;
            projectileFeature.onUsePrimary(world, player, hand);
        }
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = player.func_184586_b(hand);
        boolean active = false;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "harvest")) {
            HarvestEquipmentFeature harvestFeature = (HarvestEquipmentFeature)equipmentFeature;
            if (!harvestFeature.onBlockUsed(world, player, pos, itemStack, facing)) continue;
            active = true;
        }
        if (active) {
            player.func_184598_c(hand);
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public boolean func_111207_a(ItemStack itemStack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        boolean entityInteraction = false;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "harvest")) {
            HarvestEquipmentFeature harvestFeature = (HarvestEquipmentFeature)equipmentFeature;
            if (!harvestFeature.onEntityInteraction(player, target, itemStack)) continue;
            entityInteraction = true;
        }
        return entityInteraction;
    }

    public Set<String> getToolClasses(ItemStack itemStack) {
        HashMap<String, Boolean> toolTypes = new HashMap<String, Boolean>();
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "harvest")) {
            HarvestEquipmentFeature harvestFeature = (HarvestEquipmentFeature)equipmentFeature;
            String toolType = harvestFeature.getToolType();
            if (toolType == null) continue;
            toolTypes.put(toolType, true);
        }
        return toolTypes.keySet();
    }

    public int getHarvestLevel(ItemStack itemStack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        int harvestLevel = -1;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "harvest")) {
            HarvestEquipmentFeature harvestFeature = (HarvestEquipmentFeature)equipmentFeature;
            if (harvestLevel >= harvestFeature.harvestLevel || !toolClass.equals(harvestFeature.getToolType())) continue;
            harvestLevel = harvestFeature.harvestLevel;
        }
        return harvestLevel;
    }

    public boolean canHarvestBlock(IBlockState blockState, ItemStack itemStack) {
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "harvest")) {
            HarvestEquipmentFeature harvestFeature = (HarvestEquipmentFeature)equipmentFeature;
            if (!harvestFeature.canHarvestBlock(blockState)) continue;
            return true;
        }
        return false;
    }

    public float func_150893_a(ItemStack itemStack, IBlockState blockState) {
        float speed = 1.0f;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "harvest")) {
            HarvestEquipmentFeature harvestFeature = (HarvestEquipmentFeature)equipmentFeature;
            speed += harvestFeature.getHarvestSpeed(blockState);
        }
        return speed;
    }

    public boolean func_179218_a(ItemStack itemStack, World worldIn, IBlockState blockState, BlockPos pos, EntityLivingBase entityLiving) {
        if (worldIn.field_72995_K) {
            return super.func_179218_a(itemStack, worldIn, blockState, pos, entityLiving);
        }
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "harvest")) {
            HarvestEquipmentFeature harvestFeature = (HarvestEquipmentFeature)equipmentFeature;
            harvestFeature.onBlockDestroyed(worldIn, blockState, pos, entityLiving);
        }
        return super.func_179218_a(itemStack, worldIn, blockState, pos, entityLiving);
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase primaryTarget, EntityLivingBase attacker) {
        double sweepAngle;
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(attacker);
        boolean attackOnCooldown = false;
        if (extendedEntity != null) {
            int currentCooldown = extendedEntity.getProjectileCooldown(1, "equipment_melee");
            int weaponCooldown = 9 * (int)this.getDamageCooldown(itemStack);
            boolean bl = attackOnCooldown = currentCooldown > 0;
            if (currentCooldown < weaponCooldown) {
                extendedEntity.setProjectileCooldown(1, "equipment_melee", weaponCooldown);
            }
        }
        ArrayList<EntityLivingBase> targets = new ArrayList<EntityLivingBase>();
        targets.add(primaryTarget);
        if (attacker != null && !attacker.func_130014_f_().field_72995_K && !attacker.func_70093_af() && !attackOnCooldown && (sweepAngle = this.getDamageSweep(itemStack) / 2.0) > 0.0) {
            float sweepDamage = (float)this.getDamageAmount(itemStack);
            double sweepRange = 1.0 + this.getDamageRange(itemStack);
            List possibleTargets = attacker.func_130014_f_().func_72872_a(EntityLivingBase.class, attacker.func_174813_aQ().func_72314_b(sweepRange, sweepRange, sweepRange));
            for (EntityLivingBase possibleTarget : possibleTargets) {
                Object possibleTameableTarget;
                if (possibleTarget == attacker || possibleTarget == primaryTarget || !possibleTarget.func_70089_S() || possibleTarget instanceof EntityPlayer || possibleTarget instanceof EntityTameable && ((possibleTameableTarget = (EntityTameable)possibleTarget).func_70902_q() != null && !attacker.func_130014_f_().func_73046_m().func_71219_W() || possibleTameableTarget.func_70902_q() == attacker) || possibleTarget instanceof TameableCreatureEntity && (((TameableCreatureEntity)((Object)(possibleTameableTarget = (TameableCreatureEntity)possibleTarget))).getPlayerOwner() != null && !attacker.func_130014_f_().func_73046_m().func_71219_W() || ((TameableCreatureEntity)((Object)possibleTameableTarget)).getPlayerOwner() == attacker)) continue;
                double targetXDist = possibleTarget.field_70165_t - attacker.field_70165_t;
                double targetZDist = attacker.field_70161_v - possibleTarget.field_70161_v;
                double targetAngleAbsolute = 180.0 + Math.toDegrees(Math.atan2(targetXDist, targetZDist));
                double targetAngle = Math.abs(targetAngleAbsolute - (double)attacker.field_70177_z);
                if (targetAngle > 180.0) {
                    targetAngle = 180.0 - (targetAngle - 180.0);
                }
                if (targetAngle > sweepAngle) continue;
                targets.add(possibleTarget);
                DamageSource sweepSource = DamageSource.field_76377_j;
                if (attacker instanceof EntityPlayer) {
                    sweepSource = DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker));
                }
                possibleTarget.func_70097_a(sweepSource, sweepDamage);
            }
        }
        if (attacker instanceof EntityPlayer && targets.size() > 1) {
            EntityPlayer playerAttacker = (EntityPlayer)attacker;
            playerAttacker.func_184810_cG();
            attacker.func_130014_f_().func_184148_a(null, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, SoundEvents.field_187730_dW, attacker.func_184176_by(), 1.0f, 1.0f);
        }
        for (EntityLivingBase target : targets) {
            double knockback = this.getDamageKnockback(itemStack);
            if (knockback != 0.0 && attacker != null && target != null) {
                double xDist = attacker.field_70165_t - target.field_70165_t;
                double zDist = attacker.field_70161_v - target.field_70161_v;
                double xzDist = Math.max((double)MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist)), 0.01);
                double motionCap = 10.0;
                if (target.field_70159_w < motionCap && target.field_70159_w > -motionCap && target.field_70179_y < motionCap && target.field_70179_y > -motionCap) {
                    target.func_70024_g(-(xDist / xzDist * knockback + target.field_70159_w * knockback), 0.0, -(zDist / xzDist * knockback + target.field_70179_y * knockback));
                }
            }
            for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "effect")) {
                EffectEquipmentFeature effectFeature = (EffectEquipmentFeature)equipmentFeature;
                effectFeature.onHitEntity(itemStack, target, attacker);
            }
            for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "summon")) {
                SummonEquipmentFeature summonFeature = (SummonEquipmentFeature)equipmentFeature;
                summonFeature.onHitEntity(itemStack, target, attacker);
            }
            for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "projectile")) {
                ProjectileEquipmentFeature projectileFeature = (ProjectileEquipmentFeature)equipmentFeature;
                projectileFeature.onHitEntity(itemStack, target, attacker);
            }
        }
        return true;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack itemStack) {
        Multimap multimap = super.func_111205_h(slot);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.getDamageAmount(itemStack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -this.getDamageCooldown(itemStack), 0));
        }
        return multimap;
    }

    public double getDamageAmount(ItemStack itemStack) {
        double damage = 0.0;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "damage")) {
            DamageEquipmentFeature damageFeature = (DamageEquipmentFeature)equipmentFeature;
            damage += (double)damageFeature.damageAmount;
        }
        return damage;
    }

    public double getDamageCooldown(ItemStack itemStack) {
        double cooldown = 0.0;
        double i = 0.0;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "damage")) {
            DamageEquipmentFeature damageFeature = (DamageEquipmentFeature)equipmentFeature;
            cooldown += damageFeature.damageCooldown;
            i += 1.0;
        }
        if (i == 0.0) {
            return 2.4;
        }
        cooldown = 2.4 * (cooldown / i);
        return Math.min(3.5, cooldown);
    }

    public double getDamageRange(ItemStack itemStack) {
        double range = 0.0;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "damage")) {
            DamageEquipmentFeature damageFeature = (DamageEquipmentFeature)equipmentFeature;
            range += damageFeature.damageRange;
        }
        return range;
    }

    public double getDamageKnockback(ItemStack itemStack) {
        double knockback = 0.0;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "damage")) {
            DamageEquipmentFeature damageFeature = (DamageEquipmentFeature)equipmentFeature;
            knockback += damageFeature.damageKnockback;
        }
        return knockback;
    }

    public double getDamageSweep(ItemStack itemStack) {
        double sweep = 0.0;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "damage")) {
            DamageEquipmentFeature damageFeature = (DamageEquipmentFeature)equipmentFeature;
            sweep += damageFeature.damageSweep;
        }
        return sweep;
    }

    @Override
    public ModelResourceLocation getModelResourceLocation() {
        return new ModelResourceLocation(new ResourceLocation("lycanitesmobs", "equipmentpart"), "inventory");
    }

    public ResourceLocation getTexture(ItemStack itemStack) {
        return AssetManager.getTexture(this.itemName);
    }

    static {
        PART_LIMIT = 20;
    }
}

