/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.pets;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.pets.DonationFamiliars;
import com.lycanitesmobs.core.pets.PetEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class PetManager {
    public EntityLivingBase host;
    public Map<UUID, PetEntry> entries = new HashMap<UUID, PetEntry>();
    public List<PetEntry> newEntries = new ArrayList<PetEntry>();
    public List<PetEntry> removedEntries = new ArrayList<PetEntry>();
    public Map<UUID, NBTTagCompound> entryNBTs = new HashMap<UUID, NBTTagCompound>();

    public PetManager(EntityLivingBase host) {
        this.host = host;
    }

    public boolean hasEntry(PetEntry petEntry) {
        return this.entries.containsKey(petEntry.petEntryID);
    }

    public void addEntry(PetEntry petEntry) {
        if (this.entries.containsKey(petEntry.petEntryID)) {
            LycanitesMobs.logWarning("", "[Pet Manager] Tried to add a Pet Entry that is already added!");
            return;
        }
        if (this.entryNBTs.containsKey(petEntry.petEntryID)) {
            petEntry.readFromNBT(this.entryNBTs.get(petEntry.petEntryID));
        }
        this.entries.put(petEntry.petEntryID, petEntry);
        petEntry.onAdd(this);
        this.newEntries.add(petEntry);
    }

    public void removeEntry(PetEntry petEntry) {
        if (!this.entries.containsValue(petEntry)) {
            LycanitesMobs.logWarning("", "[Pet Manager] Tried to remove a pet entry that isn't added!");
            return;
        }
        this.entries.remove(petEntry.petEntryID);
    }

    public PetEntry getEntry(UUID id) {
        return this.entries.get(id);
    }

    public List<PetEntry> createEntryListByType(String type) {
        ArrayList<PetEntry> filteredEntries = new ArrayList<PetEntry>();
        for (PetEntry petEntry : this.entries.values()) {
            if (!type.equalsIgnoreCase(petEntry.getType())) continue;
            filteredEntries.add(petEntry);
        }
        return filteredEntries;
    }

    public void onUpdate(World world) {
        ExtendedPlayer extendedPlayer;
        if (!this.entryNBTs.isEmpty()) {
            for (PetEntry petEntry : this.entries.values()) {
                if (!this.entryNBTs.containsKey(petEntry.petEntryID)) continue;
                petEntry.readFromNBT(this.entryNBTs.get(petEntry.petEntryID));
                this.entryNBTs.remove(petEntry.petEntryID);
            }
            for (NBTTagCompound nBTTagCompound : this.entryNBTs.values()) {
                if (this.host instanceof EntityPlayer && nBTTagCompound.func_74779_i("Type").equalsIgnoreCase("familiar") && (!DonationFamiliars.instance.playerFamiliars.containsKey(this.host.func_110124_au()) || !DonationFamiliars.instance.playerFamiliars.get(this.host.func_110124_au()).containsKey(nBTTagCompound.func_186857_a("UUID")))) continue;
                PetEntry petEntry = new PetEntry(nBTTagCompound.func_186857_a("UUID"), nBTTagCompound.func_74779_i("Type"), this.host, nBTTagCompound.func_74779_i("SummonType"));
                petEntry.readFromNBT(nBTTagCompound);
                if (!petEntry.active) continue;
                this.addEntry(petEntry);
            }
            this.entryNBTs.clear();
        }
        if (this.newEntries.size() > 0) {
            if (!world.field_72995_K && this.host instanceof EntityPlayer) {
                for (PetEntry petEntry : this.newEntries) {
                    ExtendedPlayer playerExt2 = ExtendedPlayer.getForPlayer((EntityPlayer)this.host);
                    if (playerExt2 == null) continue;
                    playerExt2.sendPetEntryToPlayer(petEntry);
                }
            }
            this.newEntries = new ArrayList<PetEntry>();
        }
        int newSpiritReserved = 0;
        for (PetEntry petEntry : this.entries.values()) {
            ExtendedPlayer playerExt3;
            if (petEntry.host != this.host) {
                petEntry.setOwner(this.host);
            }
            if (this.host instanceof EntityPlayer && (playerExt3 = ExtendedPlayer.getForPlayer((EntityPlayer)this.host)) != null && petEntry.usesSpirit()) {
                int spiritCost = petEntry.getSpiritCost();
                if (petEntry.spawningActive && petEntry.active && (playerExt3.spirit + playerExt3.spiritReserved < (newSpiritReserved += spiritCost) || newSpiritReserved > playerExt3.spiritMax)) {
                    petEntry.spawningActive = false;
                    newSpiritReserved -= spiritCost;
                }
            }
            if (petEntry.active) {
                petEntry.onUpdate(world);
                continue;
            }
            this.removedEntries.add(petEntry);
        }
        if (this.removedEntries.size() > 0) {
            for (PetEntry petEntry : this.removedEntries) {
                this.removeEntry(petEntry);
            }
            this.removedEntries = new ArrayList<PetEntry>();
        }
        if (this.host instanceof EntityPlayer && (extendedPlayer = ExtendedPlayer.getForPlayer((EntityPlayer)this.host)) != null) {
            extendedPlayer.spiritReserved = newSpiritReserved;
        }
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (!nbtTagCompound.func_74764_b("PetManager")) {
            return;
        }
        NBTTagList entryList = nbtTagCompound.func_150295_c("PetManager", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            NBTTagCompound nbtEntry = entryList.func_150305_b(i);
            if (!nbtEntry.func_186855_b("UUID") && nbtEntry.func_74764_b("EntryName")) {
                LycanitesMobs.logInfo("", "[Pets] Converting Pet Entry NBT from older mod version: " + nbtEntry.func_74779_i("EntryName") + "...");
                nbtEntry.func_186854_a("UUID", UUID.randomUUID());
            }
            if (nbtEntry.func_186855_b("UUID")) {
                this.entryNBTs.put(nbtEntry.func_186857_a("UUID"), nbtEntry);
                continue;
            }
            LycanitesMobs.logWarning("", "[Pets] A Pet Entry was missing a UUID and EntryName, this is either a bug or NBT data has been tampered with, please report this!");
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList entryList = new NBTTagList();
        for (PetEntry petEntry : this.entries.values()) {
            NBTTagCompound nbtEntry = new NBTTagCompound();
            petEntry.writeToNBT(nbtEntry);
            entryList.func_74742_a((NBTBase)nbtEntry);
        }
        nbtTagCompound.func_74782_a("PetManager", (NBTBase)entryList);
    }
}

