/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.base.interfaces;

import com.wynprice.secretroomsmod.SecretRooms5;
import com.wynprice.secretroomsmod.base.interfaces.ISecretBlock;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public interface ISecretTileEntity
extends ITickable {
    public static final HashMap<Integer, HashMap<BlockPos, IBlockState>> RENDER_MAP = new HashMap();

    public static HashMap<BlockPos, IBlockState> getMap(World world) {
        if (!RENDER_MAP.containsKey(world.field_73011_w.getDimension())) {
            RENDER_MAP.put(world.field_73011_w.getDimension(), new HashMap());
        }
        return RENDER_MAP.get(world.field_73011_w.getDimension());
    }

    public void setMirrorState(IBlockState var1);

    public void setMirrorStateForcable(IBlockState var1);

    @Nonnull
    default public IBlockState getMirrorStateSafely() {
        IBlockState mirroredState = this.getMirrorState();
        return mirroredState == null ? Blocks.field_150348_b.func_176223_P() : mirroredState;
    }

    @Nullable
    public IBlockState getMirrorState();

    public static IBlockState getMirrorState(World world, BlockPos pos) {
        IBlockState blockstate = ISecretTileEntity.getMap(world).get(pos) == null && world.func_175625_s(pos) instanceof ISecretTileEntity ? ((ISecretTileEntity)world.func_175625_s(pos)).getMirrorStateSafely() : ISecretTileEntity.getMap(world).get(pos);
        return blockstate == null ? Blocks.field_150348_b.func_176223_P() : blockstate;
    }

    public static IBlockState getMirrorState(IBlockAccess access, BlockPos pos) {
        IBlockState returnState = Blocks.field_150350_a.func_176223_P();
        if (access.func_175625_s(pos) instanceof ISecretTileEntity && ((ISecretTileEntity)access.func_175625_s(pos)).getMirrorStateSafely() != null) {
            return ((ISecretTileEntity)access.func_175625_s(pos)).getMirrorStateSafely();
        }
        if (access instanceof World) {
            returnState = ISecretTileEntity.getMirrorState((World)access, pos);
        } else if (access.func_175625_s(pos) != null && access.func_175625_s(pos).func_145831_w() != null) {
            returnState = ISecretTileEntity.getMirrorState(access.func_175625_s(pos).func_145831_w(), pos);
        } else {
            for (int dim : RENDER_MAP.keySet()) {
                if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
                    returnState = ISecretTileEntity.getMirrorState(SecretRooms5.proxy.getPlayer().field_70170_p, pos);
                    continue;
                }
                if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dim) != access) continue;
                returnState = ISecretTileEntity.getMirrorState((World)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dim), pos);
            }
        }
        return returnState == null ? Blocks.field_150348_b.func_176223_P() : returnState;
    }

    public void loadFromNBT(NBTTagCompound var1);

    default public TileEntityData readDataFromNBT(NBTTagCompound compound, NBTTagCompound tileData) {
        boolean locked;
        IBlockState mirrorState = null;
        if (!compound.func_150297_b("SecretRoomsMod", 10)) {
            locked = tileData.func_74767_n("locked");
            Block testBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(tileData.func_74779_i("MirrorBlock")));
            if (testBlock != Blocks.field_150350_a) {
                mirrorState = testBlock.func_176203_a(tileData.func_74762_e("MirrorMeta"));
            }
            if (mirrorState != null && mirrorState.func_177230_c() instanceof ISecretBlock) {
                mirrorState = null;
            }
        } else {
            NBTTagCompound nbt = compound.func_74775_l("SecretRoomsMod");
            int v = nbt.func_74762_e("DataVersion");
            if (v == 1) {
                locked = nbt.func_74767_n("locked");
                mirrorState = NBTUtil.func_190008_d((NBTTagCompound)nbt.func_74775_l("MirroredState"));
            } else {
                throw new IllegalArgumentException("Secret Tile Entites Dont know how to handle data version " + v);
            }
        }
        if (mirrorState == null) {
            SecretRooms5.LOGGER.error("NBT Compound returned a null state. NBTTAG: {}", (Object)compound.toString());
            mirrorState = Blocks.field_150348_b.func_176223_P();
        }
        if (!ISecretBlock.ALL_SECRET_TILE_ENTITIES.contains(this)) {
            ISecretBlock.ALL_SECRET_TILE_ENTITIES.add((TileEntity)this);
        }
        return new TileEntityData().setMirroredState(mirrorState).setLocked(locked);
    }

    default public void writeDataToNBT(NBTTagCompound compound, TileEntityData data) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (data.getMirroredState() == null) {
            SecretRooms5.LOGGER.error("Caught null mirrored state in saving file at {}. Saving state as Stone", (Object)((TileEntity)this).func_174877_v());
            data.setMirroredState(Blocks.field_150348_b.func_176223_P());
        }
        nbt.func_74782_a("MirroredState", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)data.getMirroredState()));
        nbt.func_74768_a("DataVersion", 1);
        nbt.func_74757_a("locked", data.isLocked());
        compound.func_74782_a("SecretRoomsMod", (NBTBase)nbt);
    }

    public static class TileEntityData {
        private IBlockState mirroredState;
        private boolean locked;

        public IBlockState getMirroredState() {
            return this.mirroredState;
        }

        public TileEntityData setMirroredState(IBlockState mirroredState) {
            this.mirroredState = mirroredState;
            return this;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public TileEntityData setLocked(boolean locked) {
            this.locked = locked;
            return this;
        }
    }
}

