/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.integration.malisisdoors.malisisrenders;

import com.wynprice.secretroomsmod.SecretBlocks;
import com.wynprice.secretroomsmod.base.interfaces.ISecretBlock;
import com.wynprice.secretroomsmod.base.interfaces.ISecretTileEntity;
import com.wynprice.secretroomsmod.integration.malisisdoors.SecretBlockIconProvider;
import com.wynprice.secretroomsmod.integration.malisisdoors.SecretRenderParameters;
import com.wynprice.secretroomsmod.integration.malisisdoors.registries.blocks.SecretMalisisDoorBlock;
import com.wynprice.secretroomsmod.integration.malisisdoors.registries.tileentities.SecretMalisisTileEntityDoor;
import com.wynprice.secretroomsmod.items.TrueSightHelmet;
import com.wynprice.secretroomsmod.render.fakemodels.FakeBlockModel;
import java.util.List;
import net.malisis.core.block.IComponent;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.renderer.icon.provider.IItemIconProvider;
import net.malisis.core.util.EnumFacingUtils;
import net.malisis.doors.iconprovider.DoorIconProvider;
import net.malisis.doors.renderer.DoorRenderer;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;

public class SecretDoorRenderer
extends DoorRenderer {
    public SecretDoorRenderer() {
        super(true);
        this.registerFor(SecretMalisisTileEntityDoor.class);
    }

    protected void initialize() {
        super.initialize();
        this.ensureBlock(new Class[]{SecretMalisisDoorBlock.class});
        this.rp.calculateAOColor.set((Object)true);
        this.rp.deductParameters.set((Object)true);
    }

    public void drawShape(Shape s, RenderParameters params) {
        if (s == null) {
            return;
        }
        s.applyMatrix();
        for (Face f : s.getFaces()) {
            if (this.world.func_180495_p(this.pos).func_177230_c() instanceof ISecretBlock) {
                SecretRenderParameters sParams = new SecretRenderParameters(params, (TextureAtlasSprite)Icon.missing);
                RenderParameters sParamsFace = new RenderParameters(params);
                Face getFacing = new Face(f, sParamsFace);
                getFacing.deductParameters();
                EnumFacing facing = (EnumFacing)sParamsFace.textureSide.get();
                facing = facing == null ? EnumFacing.SOUTH : facing;
                facing = EnumFacingUtils.getRealSide((IBlockState)this.blockState, (EnumFacing)facing);
                IBlockState mirrorState = ((ISecretTileEntity)this.world.func_175625_s(this.pos)).getMirrorStateSafely();
                try {
                    mirrorState = mirrorState.func_185899_b(this.world, this.pos);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                IBlockState extendedMirrorState = mirrorState.func_177230_c().getExtendedState(mirrorState, this.world, this.pos);
                boolean facingX = ((EnumFacing)this.blockState.func_177229_b((IProperty)BlockDoor.field_176520_a)).func_176740_k() == EnumFacing.Axis.X != (Boolean)this.blockState.func_177229_b((IProperty)BlockDoor.field_176519_b);
                DoorTileEntity te = (DoorTileEntity)this.world.func_175625_s(this.blockState.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? this.pos : this.pos.func_177977_b());
                if (te.getTimer().elapsedTick() > (long)te.getOpeningTime() && te.isMoving()) {
                    boolean bl = facingX = !facingX;
                }
                if (!facingX) {
                    facing = facing.func_176732_a(EnumFacing.Axis.Y);
                }
                BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)mirrorState.func_177230_c().func_180664_k());
                List quadList = Minecraft.func_71410_x().func_175602_ab().func_184389_a(mirrorState).func_188616_a(extendedMirrorState, facing, MathHelper.func_180186_a((Vec3i)this.pos));
                if (quadList.isEmpty()) {
                    quadList = Minecraft.func_71410_x().func_175602_ab().func_184389_a(mirrorState).func_188616_a(extendedMirrorState, null, MathHelper.func_180186_a((Vec3i)this.pos));
                }
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                Face controllFace = new Face(f, (RenderParameters)sParams);
                for (BakedQuad quad : quadList) {
                    Icon icon = new Icon(quad.func_187508_a());
                    int uvIndex = quad.getFormat().func_177344_b(0) / 4;
                    icon.setUVs(Float.intBitsToFloat(quad.func_178209_a()[0 * quad.getFormat().func_181719_f() + uvIndex]), Float.intBitsToFloat(quad.func_178209_a()[0 * quad.getFormat().func_181719_f() + uvIndex + 1]), Float.intBitsToFloat(quad.func_178209_a()[2 * quad.getFormat().func_181719_f() + uvIndex]), Float.intBitsToFloat(quad.func_178209_a()[2 * quad.getFormat().func_181719_f() + uvIndex + 1]));
                    sParams.quadSprite.set((Object)icon);
                    if (TrueSightHelmet.isHelmet()) {
                        sParams.quadSprite.set((Object)FakeBlockModel.getModel(new ResourceLocation("secretroomsmod", "block/secret_" + (this.block == SecretBlocks.SECRET_WOODEN_DOOR ? "wooden" : "iron") + "_door")).func_177554_e());
                    }
                    if (!quad.func_178212_b() || Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof TrueSightHelmet) {
                        sParams.colorMultiplier.set((Object)-1);
                    } else {
                        sParams.colorMultiplier.set((Object)Minecraft.func_71410_x().func_184125_al().func_186724_a(mirrorState, this.world, this.pos, quad.func_178211_c()));
                    }
                    this.drawFace(new Face(f, (RenderParameters)sParams), sParams);
                }
                continue;
            }
            this.drawFace(f, params);
        }
    }

    protected boolean shouldRenderFace(Face face, RenderParameters params) {
        boolean ret = super.shouldRenderFace(face, params);
        if (ret) {
            if (!this.topBlock && face.name().equals("Top")) {
                return false;
            }
            if (this.topBlock && face.name().equals("Bottom")) {
                return false;
            }
        }
        return ret;
    }

    protected Icon getIcon(Face face, RenderParameters params) {
        if (params.icon.get() != null) {
            return (Icon)params.icon.get();
        }
        DoorIconProvider iconProvider0 = (DoorIconProvider)IComponent.getComponent(DoorIconProvider.class, (Object)this.block);
        if (iconProvider0 == null) {
            if (params != null && params.icon.get() != null) {
                return (Icon)params.icon.get();
            }
            IIconProvider iconProvider = this.getIconProvider(params);
            if (iconProvider instanceof IItemIconProvider && this.itemStack != null) {
                return ((IItemIconProvider)iconProvider).getIcon(this.itemStack);
            }
            if (iconProvider instanceof IBlockIconProvider && this.block != null) {
                IBlockIconProvider iblockp;
                EnumFacing side;
                EnumFacing enumFacing = side = params != null ? (EnumFacing)params.textureSide.get() : EnumFacing.SOUTH;
                if (params != null && this.shouldRotateIcon(params)) {
                    side = EnumFacingUtils.getRealSide((IBlockState)this.blockState, (EnumFacing)side);
                }
                if ((iblockp = (IBlockIconProvider)iconProvider) instanceof SecretBlockIconProvider) {
                    ((SecretBlockIconProvider)iblockp).current_params.set(params);
                }
                if (this.renderType == RenderType.BLOCK || this.renderType == RenderType.TILE_ENTITY) {
                    return iblockp.getIcon(this.world, this.pos, this.blockState, side);
                }
                if (this.renderType == RenderType.ITEM) {
                    return iblockp.getIcon(this.itemStack, side);
                }
            }
            return iconProvider != null ? iconProvider.getIcon() : Icon.missing;
        }
        return iconProvider0.getIcon(this.topBlock, this.hingeLeft, (EnumFacing)params.textureSide.get());
    }
}

