/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.network.packets;

import com.wynprice.secretroomsmod.SecretItems;
import com.wynprice.secretroomsmod.base.BaseMessagePacket;
import com.wynprice.secretroomsmod.handler.EnergizedPasteHandler;
import com.wynprice.secretroomsmod.items.CamouflagePaste;
import com.wynprice.secretroomsmod.network.SecretNetwork;
import com.wynprice.secretroomsmod.network.packets.MessagePacketSyncEnergizedPaste;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;

public class MessagePacketEnergizedPaste
extends BaseMessagePacket<MessagePacketEnergizedPaste> {
    private BlockPos pos;
    private boolean set;

    public MessagePacketEnergizedPaste() {
    }

    public MessagePacketEnergizedPaste(BlockPos pos, boolean set) {
        this.pos = pos;
        this.set = set;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.set = buf.readBoolean();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeBoolean(this.set);
    }

    private boolean isItem(ItemStack stack) {
        return stack.func_77960_j() == 1 && stack.func_77973_b() instanceof CamouflagePaste;
    }

    @Override
    public void onReceived(MessagePacketEnergizedPaste message, EntityPlayer player) {
        if (message.set) {
            IBlockState state;
            Block block;
            ItemStack stack;
            EnumHand hand;
            Object object = this.isItem(player.func_184614_ca()) ? EnumHand.MAIN_HAND : (hand = this.isItem(player.func_184592_cb()) ? EnumHand.OFF_HAND : null);
            if (hand != null && (stack = player.func_184586_b(hand)).func_77942_o() && stack.func_77978_p().func_150297_b("hit_block", 8) && stack.func_77978_p().func_150297_b("hit_meta", 99) && (block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(stack.func_77978_p().func_74779_i("hit_block")))) != Blocks.field_150350_a && EnergizedPasteHandler.canBlockBeMirrored(block, player.field_70170_p, state = block.func_176203_a(stack.func_77978_p().func_74762_e("hit_meta")), message.pos) && EnergizedPasteHandler.canBlockBeReplaced(player.field_70170_p.func_180495_p(message.pos).func_177230_c(), player.field_70170_p, player.field_70170_p.func_180495_p(message.pos), message.pos)) {
                EnergizedPasteHandler.putState(player.field_70170_p, message.pos, state);
                SecretNetwork.sendToAll(new MessagePacketSyncEnergizedPaste(player.field_70170_p.field_73011_w.getDimension(), message.pos, state, true));
                player.func_184609_a(hand);
            }
        } else {
            if (((EntityPlayerMP)player).field_71134_c.func_73081_b() == GameType.SURVIVAL && EnergizedPasteHandler.hasReplacedState(player.field_70170_p, message.pos)) {
                IBlockState state = EnergizedPasteHandler.getReplacedState(player.field_70170_p, message.pos);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("hit_block", state.func_177230_c().getRegistryName().toString());
                nbt.func_74768_a("hit_meta", state.func_177230_c().func_176201_c(state));
                nbt.func_74768_a("hit_color", state.func_185909_g((IBlockAccess)player.field_70170_p, (BlockPos)message.pos).field_76291_p);
                ItemStack stack = new ItemStack(SecretItems.CAMOUFLAGE_PASTE, 1, 1);
                stack.func_77982_d(nbt);
                boolean flag = player.field_71071_by.func_70441_a(stack);
                if (flag) {
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    player.field_71069_bz.func_75142_b();
                } else {
                    EntityItem entityitem = new EntityItem(player.field_70170_p, (double)message.pos.func_177958_n() + 0.5, (double)message.pos.func_177956_o() + 1.0, (double)message.pos.func_177952_p() + 0.5, stack);
                    entityitem.func_174868_q();
                    entityitem.func_145797_a(player.func_70005_c_());
                    player.field_70170_p.func_72838_d((Entity)entityitem);
                }
            }
            EnergizedPasteHandler.removeReplacedState(player.field_70170_p.field_73011_w.getDimension(), message.pos);
            SecretNetwork.sendToAll(new MessagePacketSyncEnergizedPaste(player.field_70170_p.field_73011_w.getDimension(), message.pos, null, false));
        }
    }
}

