/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.style;

import com.google.common.base.Charsets;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.HashMap;
import moe.plushie.armourers_workshop.client.gui.style.GuiStyle;
import moe.plushie.armourers_workshop.client.gui.style.GuiStyleSerializer;
import moe.plushie.armourers_workshop.utils.ModLogger;
import moe.plushie.armourers_workshop.utils.SerializeHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiResourceManager
implements IResourceManagerReloadListener {
    private static final HashMap<ResourceLocation, GuiStyle> GUI_RESOURCE_MAP = new HashMap();
    private static final String GUI_ASSETS_LOCATION = "%s:assets/%s";

    public GuiResourceManager() {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        if (resourceManager instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)resourceManager).func_110542_a((IResourceManagerReloadListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_110549_a(IResourceManager resourceManager) {
        ModLogger.log("Loading GUI resources.");
        HashMap<ResourceLocation, GuiStyle> hashMap = GUI_RESOURCE_MAP;
        synchronized (hashMap) {
            GUI_RESOURCE_MAP.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GuiStyle getGuiJsonInfo(ResourceLocation resourceLocation) {
        HashMap<ResourceLocation, GuiStyle> hashMap = GUI_RESOURCE_MAP;
        synchronized (hashMap) {
            if (!GUI_RESOURCE_MAP.containsKey(resourceLocation)) {
                GUI_RESOURCE_MAP.put(resourceLocation, GuiResourceManager.loadGuiJsonInfo(resourceLocation));
            }
            return GUI_RESOURCE_MAP.get(resourceLocation);
        }
    }

    private static GuiStyle loadGuiJsonInfo(ResourceLocation resourceLocation) {
        GuiStyle guiStyle = new GuiStyle();
        String path = String.format(GUI_ASSETS_LOCATION, resourceLocation.func_110624_b(), resourceLocation.func_110623_a());
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
            String data = SerializeHelper.readFile(resource.func_110527_b(), Charsets.UTF_8);
            JsonElement jsonElement = SerializeHelper.stringToJson(data);
            guiStyle = GuiStyleSerializer.deserializeJson(jsonElement);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return guiStyle;
    }
}

