/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.wardrobe.tab;

import java.util.Random;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiCustomSlider;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTabPanel;
import moe.plushie.armourers_workshop.client.gui.wardrobe.GuiWardrobe;
import moe.plushie.armourers_workshop.common.data.type.BipedRotations;
import moe.plushie.armourers_workshop.common.data.type.Rectangle_I_2D;
import moe.plushie.armourers_workshop.common.init.entities.EntityMannequin;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiUpdateMannequin;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTabWardrobeManRotations
extends GuiTabPanel
implements GuiSlider.ISlider {
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("armourers_workshop:textures/gui/wardrobe/wardrobe-2.png");
    private final EntityMannequin entityMannequin;
    private GuiButtonExt resetRotsButton;
    private GuiButtonExt randomRotsButton;
    private BipedRotations bipedRotations;
    private BipedRotations lastBipedRotations;
    private GuiCustomSlider bipedRotXslider;
    private GuiCustomSlider bipedRotYslider;
    private GuiCustomSlider bipedRotZslider;
    private Rectangle_I_2D[] bipedParts = new Rectangle_I_2D[6];
    private BipedRotations.BipedPart activeBipedPart = BipedRotations.BipedPart.HEAD;
    private boolean guiLoaded = false;
    private final String guiName = "wardrobe.tab.man_rotations";
    int partsDisplayX = 80;
    int partsDisplayY = 50;

    public GuiTabWardrobeManRotations(int tabId, GuiScreen parent, EntityMannequin entityMannequin) {
        super(tabId, parent);
        this.entityMannequin = entityMannequin;
        this.bipedRotations = new BipedRotations();
        this.lastBipedRotations = new BipedRotations();
        this.updateRotationData(entityMannequin.getBipedRotations());
    }

    @Override
    public void tabChanged(int tabIndex) {
        if (tabIndex == this.getTabId()) {
            this.updateRotationData(this.entityMannequin.getBipedRotations());
        }
    }

    public void updateRotationData(BipedRotations rots) {
        NBTTagCompound compound = new NBTTagCompound();
        rots.saveNBTData(compound);
        this.bipedRotations.loadNBTData(compound);
        this.lastBipedRotations.loadNBTData(compound);
    }

    public void updateLastRotations() {
        NBTTagCompound compound = new NBTTagCompound();
        this.bipedRotations.saveNBTData(compound);
        this.lastBipedRotations.loadNBTData(compound);
    }

    @Override
    public void initGui(int xPos, int yPos, int width, int height) {
        super.initGui(xPos, yPos, width, height);
        this.partsDisplayX = 81;
        this.partsDisplayY = 26;
        this.bipedParts[0] = new Rectangle_I_2D(this.x + this.partsDisplayX + 8, this.y + this.partsDisplayY + 3, 8, 8);
        this.bipedParts[1] = new Rectangle_I_2D(this.x + this.partsDisplayX + 8, this.y + this.partsDisplayY + 12, 8, 12);
        this.bipedParts[2] = new Rectangle_I_2D(this.x + this.partsDisplayX + 3, this.y + this.partsDisplayY + 12, 4, 12);
        this.bipedParts[3] = new Rectangle_I_2D(this.x + this.partsDisplayX + 17, this.y + this.partsDisplayY + 12, 4, 12);
        this.bipedParts[4] = new Rectangle_I_2D(this.x + this.partsDisplayX + 7, this.y + this.partsDisplayY + 25, 4, 12);
        this.bipedParts[5] = new Rectangle_I_2D(this.x + this.partsDisplayX + 13, this.y + this.partsDisplayY + 25, 4, 12);
        this.resetRotsButton = new GuiButtonExt(0, 81, 70, 100, 16, GuiHelper.getLocalizedControlName("wardrobe.tab.man_rotations", "reset", new Object[0]));
        this.randomRotsButton = new GuiButtonExt(0, 81, 90, 100, 16, GuiHelper.getLocalizedControlName("wardrobe.tab.man_rotations", "random", new Object[0]));
        this.bipedRotXslider = new GuiCustomSlider(0, 110, 25, 160, 10, "X: ", "", -180.0, 180.0, 0.0, true, true, this).setFineTuneButtons(true);
        this.bipedRotYslider = new GuiCustomSlider(0, 110, 36, 160, 10, "Y: ", "", -180.0, 180.0, 0.0, true, true, this).setFineTuneButtons(true);
        this.bipedRotZslider = new GuiCustomSlider(0, 110, 47, 160, 10, "Z: ", "", -180.0, 180.0, 0.0, true, true, this).setFineTuneButtons(true);
        if (this.bipedRotations != null) {
            float[] rots = this.bipedRotations.getPartRotations(BipedRotations.BipedPart.HEAD);
            this.setSliderValue(this.bipedRotXslider, Math.toDegrees(-rots[0]));
            this.setSliderValue(this.bipedRotYslider, Math.toDegrees(-rots[1]));
            this.setSliderValue(this.bipedRotZslider, Math.toDegrees(-rots[2]));
        }
        this.buttonList.add(this.resetRotsButton);
        this.buttonList.add(this.randomRotsButton);
        this.buttonList.add(this.bipedRotXslider);
        this.buttonList.add(this.bipedRotYslider);
        this.buttonList.add(this.bipedRotZslider);
        this.bipedPartChange(BipedRotations.BipedPart.HEAD);
        this.guiLoaded = true;
    }

    private void setSliderValue(GuiCustomSlider slider, double value) {
        slider.setValue(value);
        slider.precision = 2;
        slider.updateSlider();
    }

    private void bipedPartChange(BipedRotations.BipedPart bipedPart) {
        this.activeBipedPart = bipedPart;
        float[] rots = this.bipedRotations.getPartRotations(this.activeBipedPart);
        this.guiLoaded = false;
        this.bipedRotXslider.setValue(Math.toDegrees(-rots[0]));
        this.bipedRotYslider.setValue(Math.toDegrees(-rots[1]));
        this.bipedRotZslider.setValue(Math.toDegrees(-rots[2]));
        this.bipedRotXslider.updateSlider();
        this.bipedRotYslider.updateSlider();
        this.bipedRotZslider.updateSlider();
        this.guiLoaded = true;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        for (int i = 0; i < this.bipedParts.length; ++i) {
            if (!this.bipedParts[i].isInside(mouseX, mouseY)) continue;
            this.bipedPartChange(BipedRotations.BipedPart.values()[i]);
            break;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.resetRotsButton) {
            this.guiLoaded = false;
            this.bipedRotations.resetRotations();
            this.bipedPartChange(this.activeBipedPart);
            this.guiLoaded = true;
            this.checkAndSendRotationValues();
        }
        if (button == this.randomRotsButton) {
            this.guiLoaded = false;
            Random rnd = new Random();
            for (BipedRotations.BipedPart bipedPart : BipedRotations.BipedPart.values()) {
                float[] rots = this.bipedRotations.getPartRotations(bipedPart);
                if (bipedPart == BipedRotations.BipedPart.CHEST) continue;
                float x = 0.0f;
                float y = 0.0f;
                float z = 0.0f;
                for (int j = 0; j < 3; ++j) {
                    x += (float)Math.toRadians(rnd.nextFloat() * 60.0f - 30.0f);
                    y += (float)Math.toRadians(rnd.nextFloat() * 60.0f - 30.0f);
                    z += (float)Math.toRadians(rnd.nextFloat() * 60.0f - 30.0f);
                }
                this.bipedRotations.setPartRotations(bipedPart, x, y, z);
            }
            this.bipedPartChange(this.activeBipedPart);
            this.guiLoaded = true;
            this.checkAndSendRotationValues();
        }
    }

    public void checkAndSendRotationValues() {
        if (!this.bipedRotations.equals(this.lastBipedRotations)) {
            this.entityMannequin.setBipedRotations(this.bipedRotations);
            MessageClientGuiUpdateMannequin message = new MessageClientGuiUpdateMannequin(this.entityMannequin);
            message.setBipedRotations(this.bipedRotations);
            PacketHandler.networkWrapper.sendToServer((IMessage)message);
            this.updateLastRotations();
        }
    }

    @Override
    public void drawBackgroundLayer(float partialTickTime, int mouseX, int mouseY) {
        this.mc.field_71446_o.func_110577_a(TEXTURE_2);
        this.func_73729_b(this.x + this.partsDisplayX, this.y + this.partsDisplayY, 22, 0, 24, 40);
        for (int i = 0; i < this.bipedParts.length; ++i) {
            int colour = -855638272;
            if (this.bipedParts[i].isInside(mouseX, mouseY)) {
                colour = -855638017;
            }
            if (BipedRotations.BipedPart.values()[i] == this.activeBipedPart) {
                colour = -872349952;
            }
            GuiTabWardrobeManRotations.func_73734_a((int)this.bipedParts[i].x, (int)this.bipedParts[i].y, (int)(this.bipedParts[i].x + this.bipedParts[i].width), (int)(this.bipedParts[i].y + this.bipedParts[i].height), (int)colour);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawForegroundLayer(int mouseX, int mouseY, float partialTickTime) {
        super.drawForegroundLayer(mouseX, mouseY, partialTickTime);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-this.x), (double)(-this.y), (double)0.0);
        ((GuiWardrobe)this.parent).drawPlayerPreview(this.x, this.y, mouseX, mouseY);
        GL11.glPopMatrix();
    }

    public void onChangeSliderValue(GuiSlider slider) {
        if (!this.guiLoaded) {
            return;
        }
        float[] rots = this.bipedRotations.getPartRotations(this.activeBipedPart);
        rots[0] = (float)Math.toRadians(-this.bipedRotXslider.getValue());
        rots[1] = (float)Math.toRadians(-this.bipedRotYslider.getValue());
        rots[2] = (float)Math.toRadians(-this.bipedRotZslider.getValue());
        this.bipedRotations.setPartRotations(this.activeBipedPart, rots);
        this.checkAndSendRotationValues();
    }
}

