/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.wardrobe.tab;

import com.mojang.authlib.GameProfile;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiDropDownList;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTabPanel;
import moe.plushie.armourers_workshop.client.gui.wardrobe.GuiWardrobe;
import moe.plushie.armourers_workshop.common.data.type.TextureType;
import moe.plushie.armourers_workshop.common.init.entities.EntityMannequin;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiUpdateMannequin;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTabWardrobeManTextureData
extends GuiTabPanel
implements GuiDropDownList.IDropDownListCallback {
    private final EntityMannequin entityMannequin;
    private EntityMannequin.TextureData textureData;
    private GuiDropDownList textureTypeList;
    private GuiTextField nameTextbox;
    private GuiButtonExt setNameButton;
    private final String guiName = "wardrobe.tab.man_texture";

    public GuiTabWardrobeManTextureData(int tabId, GuiScreen parent, EntityMannequin entityMannequin) {
        super(tabId, parent);
        this.entityMannequin = entityMannequin;
    }

    @Override
    public void initGui(int xPos, int yPos, int width, int height) {
        super.initGui(xPos, yPos, width, height);
        this.textureData = this.entityMannequin.getTextureData();
        this.textureTypeList = new GuiDropDownList(0, 81, 25, 80, "", this);
        this.textureTypeList.addListItem(GuiHelper.getLocalizedControlName("wardrobe.tab.man_texture", "dropdown.user", new Object[0]), TextureType.USER.toString(), true);
        this.textureTypeList.addListItem(GuiHelper.getLocalizedControlName("wardrobe.tab.man_texture", "dropdown.url", new Object[0]), TextureType.URL.toString(), true);
        this.textureTypeList.setListSelectedIndex(0);
        if (this.textureData.getTextureType() == TextureType.URL) {
            this.textureTypeList.setListSelectedIndex(1);
        }
        this.nameTextbox = new GuiTextField(-1, this.fontRenderer, this.x + 81, this.y + 70, 165, 14);
        this.nameTextbox.func_146203_f(300);
        this.setupForTextureData(this.textureData);
        this.setNameButton = new GuiButtonExt(0, 81, 90, 100, 16, GuiHelper.getLocalizedControlName("wardrobe.tab.man_texture", "set", new Object[0]));
        this.buttonList.add(this.textureTypeList);
        this.buttonList.add(this.setNameButton);
    }

    private void setupForTextureData(EntityMannequin.TextureData textureData) {
        switch (textureData.getTextureType()) {
            case NONE: {
                this.nameTextbox.func_146180_a("");
                break;
            }
            case USER: {
                this.nameTextbox.func_146184_c(true);
                if (textureData.getProfile() == null) break;
                this.nameTextbox.func_146180_a(textureData.getProfile().getName());
                break;
            }
            case URL: {
                this.nameTextbox.func_146184_c(true);
                if (StringUtils.func_151246_b((String)textureData.getUrl())) break;
                this.nameTextbox.func_146180_a(textureData.getUrl());
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        boolean clicked = super.mouseClicked(mouseX, mouseY, button);
        if (clicked) {
            this.nameTextbox.func_146195_b(false);
        }
        if (!clicked) {
            clicked = this.nameTextbox.func_146192_a(mouseX, mouseY, button);
        }
        if (!clicked && button == 1 & this.nameTextbox.func_146206_l()) {
            this.nameTextbox.func_146180_a("");
        }
        return clicked;
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.setNameButton) {
            this.sendNewTextureData();
        }
    }

    @Override
    public boolean keyTyped(char c, int keycode) {
        boolean typed = this.nameTextbox.func_146201_a(c, keycode);
        if (!typed & this.nameTextbox.func_146206_l() && 28 == keycode) {
            this.sendNewTextureData();
            this.nameTextbox.func_146195_b(false);
        }
        return typed;
    }

    @Override
    public void update() {
        this.nameTextbox.func_146178_a();
    }

    @Override
    public void drawBackgroundLayer(float partialTickTime, int mouseX, int mouseY) {
        this.nameTextbox.func_146194_f();
    }

    @Override
    public void drawForegroundLayer(int mouseX, int mouseY, float partialTickTime) {
        super.drawForegroundLayer(mouseX, mouseY, partialTickTime);
        this.textureTypeList.drawForeground(this.mc, mouseX - this.x, mouseY - this.y, partialTickTime);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-this.x), (double)(-this.y), (double)0.0);
        ((GuiWardrobe)this.parent).drawPlayerPreview(this.x, this.y, mouseX, mouseY);
        GL11.glPopMatrix();
    }

    @Override
    public void onDropDownListChanged(GuiDropDownList dropDownList) {
    }

    private TextureType getSelectedTextureType() {
        return TextureType.valueOf(this.textureTypeList.getListSelectedItem().tag);
    }

    private void sendNewTextureData() {
        TextureType textureType = this.getSelectedTextureType();
        String textureString = this.nameTextbox.func_146179_b();
        if (StringUtils.func_151246_b((String)textureString)) {
            textureType = TextureType.NONE;
        }
        EntityMannequin.TextureData textureData = null;
        switch (textureType) {
            case NONE: {
                textureData = new EntityMannequin.TextureData();
                break;
            }
            case USER: {
                textureData = new EntityMannequin.TextureData(new GameProfile(null, textureString));
                break;
            }
            case URL: {
                textureData = new EntityMannequin.TextureData(textureString);
            }
        }
        this.entityMannequin.setTextureData(textureData, false);
        MessageClientGuiUpdateMannequin message = new MessageClientGuiUpdateMannequin(this.entityMannequin);
        message.setTextureData(textureData);
        PacketHandler.networkWrapper.sendToServer((IMessage)message);
    }
}

