/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.library.global.task;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URLEncoder;
import moe.plushie.armourers_workshop.common.library.global.MultipartForm;
import moe.plushie.armourers_workshop.common.library.global.permission.PermissionSystem;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTask;

public class GlobalTaskSkinSearch
extends GlobalTask<JsonObject> {
    private static final String URL = "skin-search-page.php?search=%s&maxFileVersion=%d&pageIndex=%d&pageSize=%d";
    private final String searchText;
    private final String searchTypes;
    private final int pageIndex;
    private final int pageSize;
    private SearchColumnType searchOrderColumn = SearchColumnType.DATE_CREATED;
    private SearchOrderType searchOrder = SearchOrderType.DESC;

    public GlobalTaskSkinSearch(String searchText, String searchTypes, int pageIndex, int pageSize) {
        super(PermissionSystem.PlushieAction.SKIN_SEARCH, false);
        this.searchText = searchText;
        this.searchTypes = searchTypes;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public GlobalTaskSkinSearch setSearchOrderColumn(SearchColumnType searchOrderColumn) {
        this.searchOrderColumn = searchOrderColumn;
        return this;
    }

    public GlobalTaskSkinSearch setSearchOrder(SearchOrderType searchOrder) {
        this.searchOrder = searchOrder;
        return this;
    }

    @Override
    public JsonObject call() throws Exception {
        this.permissionCheck();
        String url = String.format(this.getBaseUrl() + URL, URLEncoder.encode(this.searchText, "UTF-8"), 13, this.pageIndex, this.pageSize);
        MultipartForm multipartForm = new MultipartForm(url);
        multipartForm.addText("searchTypes", this.searchTypes);
        if (this.searchOrderColumn != null) {
            multipartForm.addText("searchOrderColumn", this.searchOrderColumn.toString().toLowerCase());
        }
        if (this.searchOrder != null) {
            multipartForm.addText("searchOrder", this.searchOrder.toString());
        }
        String data = multipartForm.upload();
        return new JsonParser().parse(data).getAsJsonObject();
    }

    public static enum SearchOrderType {
        DESC,
        ASC;


        public String getLangKey() {
            return "skin_search_order.armourers_workshop:" + this.toString().toLowerCase();
        }
    }

    public static enum SearchColumnType {
        ID,
        USER_ID,
        NAME,
        DESCRIPTION,
        DATE_CREATED,
        SKIN_TYPE,
        DOWNLOADS,
        RATING,
        RATING_COUNT;


        public String getLangKey() {
            return "skin_search_column.armourers_workshop:" + this.toString().toLowerCase();
        }
    }
}

