/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.entity.EntityNPCInterface;

public class VisibilityController {
    public static VisibilityController instance = new VisibilityController();
    private Map<Integer, EntityNPCInterface> trackedEntityHashTable = new TreeMap<Integer, EntityNPCInterface>();

    public void trackNpc(EntityNPCInterface npc) {
        if (!CustomNpcs.EnableInvisibleNpcs) {
            return;
        }
        boolean hasOptions = npc.display.hasVisibleOptions();
        if ((hasOptions || npc.display.getVisible() != 0) && !this.trackedEntityHashTable.containsKey(npc.func_145782_y())) {
            this.trackedEntityHashTable.put(npc.func_145782_y(), npc);
        }
        if (!hasOptions && npc.display.getVisible() == 0 && this.trackedEntityHashTable.containsKey(npc.func_145782_y())) {
            this.trackedEntityHashTable.remove(npc.func_145782_y());
        }
    }

    public void onUpdate(EntityPlayerMP player) {
        if (!CustomNpcs.EnableInvisibleNpcs) {
            return;
        }
        WorldServer world = player.func_71121_q();
        for (Map.Entry<Integer, EntityNPCInterface> entry : this.trackedEntityHashTable.entrySet()) {
            VisibilityController.checkIsVisible(entry.getValue(), player);
        }
    }

    public static void checkIsVisible(EntityNPCInterface npc, EntityPlayerMP playerMP) {
        if (!CustomNpcs.EnableInvisibleNpcs) {
            return;
        }
        if (npc.display.isVisibleTo(playerMP) || playerMP.func_175149_v() || playerMP.func_184614_ca().func_77973_b() == CustomItems.wand) {
            npc.setVisible(playerMP);
        } else {
            npc.setInvisible(playerMP);
        }
    }
}

