/*
 * Decompiled with CFR 0.152.
 */
package com.suppergerrie2.alwayseat;

import com.suppergerrie2.alwayseat.AlwaysEatMod;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.item.ItemFood;
import net.minecraftforge.common.config.Config;

@Config(modid="salwayseat")
@Config.LangKey(value="salwayseat.config")
public class AlwaysEatConfig {
    @Config.Name(value="Whitelist or blacklist foods")
    @Config.Comment(value={"If whitelist only the items in the list will be made edible, if blacklist all food items except the items in list will be made edible."})
    @Config.RequiresMcRestart
    public static AlwaysEatMod.Mode mode = AlwaysEatMod.Mode.BLACKLIST;
    @Config.Name(value="Items to whitelist/blacklist")
    @Config.Comment(value={"The registry names of the items to blacklist or whitelist (depending on the mode). To see registry names press f3+h and hover over an item in your inventory."})
    @Config.RequiresMcRestart
    public static String[] items = new String[0];
    @Config.Ignore
    static HashSet<String> itemsToIgnore;

    static boolean shouldEffectItem(ItemFood item) {
        if (itemsToIgnore == null) {
            itemsToIgnore = new HashSet();
            itemsToIgnore.addAll(Arrays.asList(items));
        }
        if (mode == AlwaysEatMod.Mode.BLACKLIST) {
            return !itemsToIgnore.contains(item.getRegistryName().toString());
        }
        return itemsToIgnore.contains(item.getRegistryName().toString());
    }
}

