/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import java.util.Arrays;

public final class ShortIndirectHeaps {
    private ShortIndirectHeaps() {
    }

    public static int downHeap(short[] refArray, int[] heap, int[] inv, int size2, int i, ShortComparator c) {
        assert (i < size2);
        int e = heap[i];
        short E = refArray[e];
        if (c == null) {
            int child;
            while ((child = (i << 1) + 1) < size2) {
                int t = heap[child];
                int right = child + 1;
                if (right < size2 && refArray[heap[right]] < refArray[t]) {
                    child = right;
                    t = heap[child];
                }
                if (E > refArray[t]) {
                    heap[i] = t;
                    inv[heap[i]] = i;
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = (i << 1) + 1) < size2) {
                int t = heap[child];
                int right = child + 1;
                if (right < size2 && c.compare(refArray[heap[right]], refArray[t]) < 0) {
                    child = right;
                    t = heap[child];
                }
                if (c.compare(E, refArray[t]) > 0) {
                    heap[i] = t;
                    inv[heap[i]] = i;
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        inv[e] = i;
        return i;
    }

    public static int upHeap(short[] refArray, int[] heap, int[] inv, int size2, int i, ShortComparator c) {
        assert (i < size2);
        int e = heap[i];
        short E = refArray[e];
        if (c == null) {
            int parent2;
            int t;
            while (i != 0 && refArray[t = heap[parent2 = i - 1 >>> 1]] > E) {
                heap[i] = t;
                inv[heap[i]] = i;
                i = parent2;
            }
        } else {
            int parent3;
            int t;
            while (i != 0 && c.compare(refArray[t = heap[parent3 = i - 1 >>> 1]], E) > 0) {
                heap[i] = t;
                inv[heap[i]] = i;
                i = parent3;
            }
        }
        heap[i] = e;
        inv[e] = i;
        return i;
    }

    public static void makeHeap(short[] refArray, int offset, int length, int[] heap, int[] inv, ShortComparator c) {
        ShortArrays.ensureOffsetLength(refArray, offset, length);
        if (heap.length < length) {
            throw new IllegalArgumentException("The heap length (" + heap.length + ") is smaller than the number of elements (" + length + ")");
        }
        if (inv.length < refArray.length) {
            throw new IllegalArgumentException("The inversion array length (" + heap.length + ") is smaller than the length of the reference array (" + refArray.length + ")");
        }
        Arrays.fill(inv, 0, refArray.length, -1);
        int i = length;
        while (i-- != 0) {
            heap[i] = offset + i;
            inv[heap[i]] = i;
        }
        i = length >>> 1;
        while (i-- != 0) {
            ShortIndirectHeaps.downHeap(refArray, heap, inv, length, i, c);
        }
    }

    public static void makeHeap(short[] refArray, int[] heap, int[] inv, int size2, ShortComparator c) {
        int i = size2 >>> 1;
        while (i-- != 0) {
            ShortIndirectHeaps.downHeap(refArray, heap, inv, size2, i, c);
        }
    }
}

