/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements;

import java.util.function.Supplier;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.framework.elements.utils.IconContainer;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;

public class GuiCollapseSection
extends GuiElement {
    protected GuiLabel title;
    protected GuiElement fields;
    protected boolean collapsed;
    protected IconContainer collapsedIcon = new IconContainer(Icons.MOVE_RIGHT, 14, 10, 0.5f, 0.5f, -2, -2);
    protected IconContainer openedIcon = new IconContainer(Icons.MOVE_DOWN, 14, 10, 0.5f, 0.5f, -2, 0);

    public GuiCollapseSection(Minecraft mc, IKey title, Supplier<Integer> titleBackground, boolean collapsed) {
        super(mc);
        this.title = Elements.label(title).background(titleBackground);
        this.title.setLeftIconContainer(this.collapsedIcon);
        this.fields = new GuiElement(mc);
        this.fields.flex().column(5).stretch().vertical().height(20);
        this.flex().column(5).stretch().vertical();
        this.add((IGuiElement)this.title);
        if (!collapsed) {
            this.add((IGuiElement)this.fields);
            this.title.setLeftIconContainer(this.openedIcon);
        }
        this.collapsed = collapsed;
    }

    public GuiCollapseSection(Minecraft mc, IKey title, Supplier<Integer> titleBackground) {
        this(mc, title, titleBackground, false);
    }

    public GuiCollapseSection(Minecraft mc, IKey title) {
        this(mc, title, () -> -2013265920 + (Integer)McLib.primaryColor.get());
    }

    public void setCollapsed(boolean collapsed) {
        if (this.collapsed != collapsed) {
            this.updateCollapse();
        }
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void addField(GuiElement element) {
        this.fields.add((IGuiElement)element);
    }

    public void addFields(GuiElement ... element) {
        this.fields.add(element);
    }

    public GuiLabel getTitle() {
        return this.title;
    }

    protected void updateCollapse() {
        if (!this.collapsed) {
            this.fields.removeFromParent();
            this.title.setLeftIconContainer(this.collapsedIcon);
            this.collapsed = true;
        } else {
            this.add((IGuiElement)this.fields);
            this.title.setLeftIconContainer(this.openedIcon);
            this.collapsed = false;
        }
    }

    @Override
    public boolean mouseClicked(GuiContext context) {
        if (super.mouseClicked(context)) {
            return true;
        }
        if (this.title.area.isInside(context)) {
            this.updateCollapse();
            this.getParent().resize();
            return true;
        }
        return false;
    }
}

