/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IViewport;
import mchorse.mclib.client.gui.framework.elements.utils.IViewportStack;
import mchorse.mclib.client.gui.utils.Area;

public class GuiViewportStack
implements IViewportStack {
    private Stack<Area> viewportStack = new Stack();
    private List<Area> viewportAreas = new ArrayList<Area>();
    private int shiftX;
    private int shiftY;

    public static GuiViewportStack fromElement(GuiElement element) {
        GuiViewportStack stack = new GuiViewportStack();
        stack.applyFromElement(element);
        return stack;
    }

    public void applyFromElement(GuiElement element) {
        ArrayList<IViewport> elements = new ArrayList<IViewport>();
        while (element != null) {
            if (element instanceof IViewport) {
                elements.add((IViewport)((Object)element));
            }
            element = element.getParent();
        }
        for (int i = elements.size() - 1; i >= 0; --i) {
            ((IViewport)elements.get(i)).apply(this);
        }
    }

    @Override
    public void reset() {
        this.shiftX = 0;
        this.shiftY = 0;
        this.viewportStack.clear();
    }

    @Override
    public Area getViewport() {
        return this.viewportStack.peek();
    }

    @Override
    public void pushViewport(Area area) {
        if (this.viewportStack.isEmpty()) {
            Area child = this.getCurrentViewportArea();
            child.copy(area);
            this.viewportStack.push(child);
        } else {
            Area current = this.viewportStack.peek();
            Area child = this.getCurrentViewportArea();
            child.copy(area);
            current.clamp(child);
            this.viewportStack.push(child);
        }
    }

    private Area getCurrentViewportArea() {
        while (this.viewportAreas.size() < this.viewportStack.size() + 1) {
            this.viewportAreas.add(new Area());
        }
        return this.viewportAreas.get(this.viewportStack.size());
    }

    @Override
    public void popViewport() {
        this.viewportStack.pop();
    }

    @Override
    public int getShiftX() {
        return this.shiftX;
    }

    @Override
    public int getShiftY() {
        return this.shiftY;
    }

    @Override
    public int globalX(int x) {
        return x - this.shiftX;
    }

    @Override
    public int globalY(int y) {
        return y - this.shiftY;
    }

    @Override
    public int localX(int x) {
        return x + this.shiftX;
    }

    @Override
    public int localY(int y) {
        return y + this.shiftY;
    }

    @Override
    public void shiftX(int x) {
        this.shiftX += x;
        if (!this.viewportStack.isEmpty()) {
            this.viewportStack.peek().x += x;
        }
    }

    @Override
    public void shiftY(int y) {
        this.shiftY += y;
        if (!this.viewportStack.isEmpty()) {
            this.viewportStack.peek().y += y;
        }
    }
}

