/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.mclib;

import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiCanvas;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.mclib.GuiDashboard;
import mchorse.mclib.client.gui.mclib.GuiDashboardPanel;
import mchorse.mclib.client.gui.utils.GuiUtils;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.math.IValue;
import mchorse.mclib.math.MathBuilder;
import mchorse.mclib.math.Variable;
import mchorse.mclib.utils.Direction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.input.Mouse;

public class GuiGraphPanel
extends GuiDashboardPanel<GuiDashboard> {
    public GuiGraphCanvas canvas;
    public GuiTextElement expression;
    public GuiIconElement help;

    public GuiGraphPanel(Minecraft mc, GuiDashboard dashboard) {
        super(mc, dashboard);
        this.canvas = new GuiGraphCanvas(mc);
        this.expression = new GuiTextElement(mc, 10000, this.canvas::parseExpression);
        this.help = new GuiIconElement(mc, Icons.HELP, b -> GuiUtils.openWebLink("https://github.com/mchorse/aperture/wiki/Math-Expressions"));
        this.help.tooltip(IKey.lang("mclib.gui.graph.help"), Direction.TOP);
        String first = "sin(x)";
        this.expression.setText(first);
        this.canvas.parseExpression(first);
        this.expression.flex().relative(this).x(10).y(1.0f, -30).w(1.0f, -20).h(20);
        this.canvas.flex().relative(this).wh(1.0f, 1.0f);
        this.help.flex().relative(this.expression).x(1.0f, -19).y(1).wh(18, 18);
        this.expression.add((IGuiElement)this.help);
        this.add(this.canvas, this.expression);
    }

    @Override
    public boolean isClientSideOnly() {
        return true;
    }

    public static class GuiGraphCanvas
    extends GuiCanvas {
        private MathBuilder builder = new MathBuilder();
        private Variable x = new Variable("x", 0.0);
        private boolean first = true;
        public IValue expression;

        public GuiGraphCanvas(Minecraft mc) {
            super(mc);
            this.builder.register(this.x);
            this.scaleY.inverse = true;
        }

        public void parseExpression(String expression) {
            try {
                this.expression = this.builder.parse(expression);
            }
            catch (Exception e) {
                this.expression = null;
            }
        }

        @Override
        public void resize() {
            super.resize();
            if (this.first) {
                this.scaleX.view(-10.0, 10.0);
                this.scaleX.calculateMultiplier();
                this.scaleY.view(-10.0, 10.0);
                this.scaleY.calculateMultiplier();
                this.first = false;
            }
        }

        @Override
        protected void drawCanvas(GuiContext context) {
            this.area.draw(-2013265920);
            this.drawVerticalGrid(context);
            this.drawHorizontalGridAndGraph(context);
        }

        private void drawVerticalGrid(GuiContext context) {
            int ty = (int)this.scaleY.from(this.area.ey());
            int by = (int)this.scaleY.from(this.area.y - 12);
            int min = Math.min(ty, by) - 1;
            int max = Math.max(ty, by) + 1;
            int mult = this.scaleY.getMult();
            min -= min % mult + mult;
            max -= max % mult - mult;
            int c = (max - min) / mult;
            for (int j = 0; j < c; ++j) {
                int y = (int)this.scaleY.to(min + j * mult);
                if (y >= this.area.ey()) continue;
                Gui.func_73734_a((int)this.area.x, (int)y, (int)this.area.ex(), (int)(y + 1), (int)0x44FFFFFF);
                this.font.func_78276_b(String.valueOf(min + j * mult), this.area.x + 4, y + 4, 0xFFFFFF);
            }
        }

        private void drawHorizontalGridAndGraph(GuiContext context) {
            int x;
            int tx = (int)this.scaleX.from(this.area.ex());
            int bx = (int)this.scaleX.from(this.area.x);
            int min = Math.min(tx, bx) - 1;
            int max = Math.max(tx, bx) + 1;
            int mult = this.scaleX.getMult();
            min -= min % mult + mult;
            max -= max % mult - mult;
            int c = (max - min) / mult;
            for (int j = 0; j < c && (x = (int)this.scaleX.to(min + j * mult)) < this.area.ex(); ++j) {
                Gui.func_73734_a((int)x, (int)this.area.y, (int)(x + 1), (int)this.area.ey(), (int)0x44FFFFFF);
                this.font.func_78276_b(String.valueOf(min + j * mult), x + 4, this.area.y + 4, 0xFFFFFF);
            }
            if (this.expression == null) {
                return;
            }
            if (Mouse.isButtonDown((int)0) && !context.isFocused()) {
                int mouseX = context.mouseX;
                double x2 = this.scaleX.from(mouseX);
                this.x.set(x2);
                double y = this.expression.get().doubleValue();
                int y1 = context.mouseY;
                int y2 = (int)this.scaleY.to(y) + 1;
                boolean isNaN = Double.isNaN(y);
                if (y1 < y2) {
                    y1 -= 12;
                }
                String coordinate = "(" + GuiTrackpadElement.FORMAT.format(x2) + ", " + (isNaN ? "undefined" : GuiTrackpadElement.FORMAT.format(y)) + ")";
                if (!isNaN) {
                    Gui.func_73734_a((int)mouseX, (int)Math.min(y1, y2), (int)(mouseX + 1), (int)Math.max(y1, y2), (int)-11012822);
                }
                int y3 = y1 < y2 ? y1 : y1 - 12;
                int w = this.font.func_78256_a(coordinate);
                Gui.func_73734_a((int)(++mouseX), (int)y3, (int)(mouseX + w + 4), (int)(y3 + 12), (int)-1);
                this.font.func_78276_b(coordinate, mouseX + 2, y3 + 2, 0);
            }
            GlStateManager.func_187441_d((float)4.0f);
            GlStateManager.func_179090_x();
            BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
            builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            int sub = 40;
            int gap = (max - min) * sub;
            for (int j = 1; j < gap; ++j) {
                double previous = (double)min + (double)(j - 1) / (double)sub;
                double current = (double)min + (double)j / (double)sub;
                this.x.set(previous);
                double y1 = this.expression.get().doubleValue();
                this.x.set(current);
                double y2 = this.expression.get().doubleValue();
                double fx1 = this.scaleX.to(previous);
                double fy1 = this.scaleY.to(y1);
                double fx2 = this.scaleX.to(current);
                double fy2 = this.scaleY.to(y2);
                builder.func_181662_b(fx1, fy1, 0.0).func_181666_a(0.0f, 0.5f, 1.0f, 1.0f).func_181675_d();
                builder.func_181662_b(fx2, fy2, 0.0).func_181666_a(0.0f, 0.5f, 1.0f, 1.0f).func_181675_d();
            }
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_187441_d((float)1.0f);
        }
    }
}

