/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.commands;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mchorse.mclib.commands.utils.L10n;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public abstract class McCommandBase
extends CommandBase {
    public static final List<String> BOOLEANS = ImmutableList.of((Object)"true", (Object)"false", (Object)"1", (Object)"0");

    public static String processSyntax(String str) {
        return str.replaceAll("\\{([\\w\\d_]+)\\}", "\u00a7$1");
    }

    public abstract L10n getL10n();

    public abstract String getSyntax();

    public String getProcessedSyntax() {
        return McCommandBase.processSyntax(this.getSyntax());
    }

    public ITextComponent getUsageMessage(ICommandSender sender) {
        TextComponentTranslation message = new TextComponentTranslation(this.getProcessedSyntax(), new Object[0]);
        message.func_150256_b().func_150238_a(TextFormatting.WHITE);
        return message.func_150257_a((ITextComponent)new TextComponentString("\n\n")).func_150257_a((ITextComponent)new TextComponentTranslation(this.func_71518_a(sender), new Object[0]));
    }

    public int getRequiredArgs() {
        return 0;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 1 && args[0].equals("-h")) {
            throw new WrongUsageException("mclib.commands.wrapper", new Object[]{this.getUsageMessage(sender)});
        }
        if (args.length < this.getRequiredArgs()) {
            throw new WrongUsageException("mclib.commands.wrapper", new Object[]{this.getUsageMessage(sender)});
        }
        try {
            this.executeCommand(server, sender, args);
        }
        catch (CommandException e) {
            if (e.getMessage().startsWith("commands.")) {
                throw e;
            }
            throw new CommandException("mclib.commands.wrapper", new Object[]{this.getL10n().error(e.getMessage(), e.func_74844_a())});
        }
    }

    public abstract void executeCommand(MinecraftServer var1, ICommandSender var2, String[] var3) throws CommandException;
}

