/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config;

import java.io.File;
import mchorse.mclib.config.Config;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueDouble;
import mchorse.mclib.config.values.ValueFloat;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.config.values.ValueRL;
import mchorse.mclib.config.values.ValueString;
import net.minecraft.util.ResourceLocation;

public class ConfigBuilder {
    private Config config;
    private Value category;

    public ConfigBuilder(String id, File file) {
        this.config = new Config(id, file);
    }

    public Config getConfig() {
        return this.config;
    }

    public Value getCategory() {
        return this.category;
    }

    public ConfigBuilder category(String id) {
        this.category = new Value(id);
        this.config.values.put(id, this.category);
        this.category.setConfig(this.config);
        return this;
    }

    public ConfigBuilder register(Value value) {
        this.category.addSubValue(value);
        value.setConfig(this.config);
        return this;
    }

    public ValueInt getInt(String id, int defaultValue) {
        ValueInt value = new ValueInt(id, defaultValue);
        this.register(value);
        return value;
    }

    public ValueInt getInt(String id, int defaultValue, int min, int max) {
        ValueInt value = new ValueInt(id, defaultValue, min, max);
        this.register(value);
        return value;
    }

    public ValueFloat getFloat(String id, float defaultValue) {
        ValueFloat value = new ValueFloat(id, defaultValue);
        this.register(value);
        return value;
    }

    public ValueFloat getFloat(String id, float defaultValue, float min, float max) {
        ValueFloat value = new ValueFloat(id, defaultValue, min, max);
        this.register(value);
        return value;
    }

    public ValueDouble getDouble(String id, double defaultValue) {
        ValueDouble value = new ValueDouble(id, defaultValue);
        this.register(value);
        return value;
    }

    public ValueDouble getDouble(String id, double defaultValue, double min, double max) {
        ValueDouble value = new ValueDouble(id, defaultValue, min, max);
        this.register(value);
        return value;
    }

    public ValueBoolean getBoolean(String id, boolean defaultValue) {
        ValueBoolean value = new ValueBoolean(id, defaultValue);
        this.register(value);
        return value;
    }

    public ValueString getString(String id, String defaultValue) {
        ValueString value = new ValueString(id, defaultValue);
        this.register(value);
        return value;
    }

    public ValueRL getRL(String id, ResourceLocation defaultValue) {
        ValueRL value = new ValueRL(id, defaultValue);
        this.register(value);
        return value;
    }
}

