/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config.values;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nonnull;
import mchorse.mclib.config.values.GenericValue;
import mchorse.mclib.utils.MathUtils;

public abstract class GenericNumberValue<T extends Number>
extends GenericValue<T> {
    protected T min;
    protected T max;

    public GenericNumberValue(String id, @Nonnull T defaultValue, @Nonnull T min, @Nonnull T max) {
        super(id);
        this.min = min == null ? this.getNullValue() : min;
        this.max = max == null ? this.getNullValue() : max;
        this.defaultValue = defaultValue == null ? this.getNullValue() : defaultValue;
        this.reset();
    }

    @Override
    public void set(T value) {
        this.value = MathUtils.clamp((Comparable)(value == null ? this.getNullValue() : value), (Comparable)this.min, (Comparable)this.max);
        this.saveLater();
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    @Override
    protected abstract T getNullValue();

    @Override
    public JsonElement valueToJSON() {
        return new JsonPrimitive((Number)this.value);
    }
}

