/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config.values;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.config.gui.GuiConfigPanel;
import mchorse.mclib.config.values.GenericValue;
import mchorse.mclib.config.values.IConfigGuiProvider;
import mchorse.mclib.config.values.IServerValue;
import mchorse.mclib.config.values.Value;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ValueBoolean
extends GenericValue<Boolean>
implements IServerValue,
IConfigGuiProvider {
    public ValueBoolean(String id) {
        super(id, false);
    }

    public ValueBoolean(String id, boolean defaultValue) {
        super(id, defaultValue);
    }

    @Override
    protected Boolean getNullValue() {
        return false;
    }

    @Override
    public void resetServer() {
        this.serverValue = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiElement> getFields(Minecraft mc, GuiConfigPanel gui) {
        GuiToggleElement toggle = new GuiToggleElement(mc, this);
        toggle.flex().reset();
        return Arrays.asList(toggle);
    }

    @Override
    public void valueFromJSON(JsonElement element) {
        this.set(element.getAsBoolean());
    }

    @Override
    public JsonElement valueToJSON() {
        return new JsonPrimitive((Boolean)this.value);
    }

    @Override
    public void valueFromNBT(NBTBase tag) {
        if (tag instanceof NBTPrimitive) {
            if (((NBTPrimitive)tag).func_150287_d() == 1) {
                this.set(true);
            } else if (((NBTPrimitive)tag).func_150287_d() == 0) {
                this.set(false);
            }
        }
    }

    @Override
    public NBTBase valueToNBT() {
        return new NBTTagInt((Boolean)this.value != false ? 1 : 0);
    }

    @Override
    public boolean parseFromCommand(String value) {
        if (value.equals("1")) {
            this.set(true);
        } else if (value.equals("0")) {
            this.set(false);
        } else {
            this.set(Boolean.parseBoolean(value));
        }
        return true;
    }

    @Override
    public void copy(Value value) {
        this.superCopy(value);
        if (value instanceof ValueBoolean) {
            this.value = ((ValueBoolean)value).value;
        }
    }

    @Override
    public void copyServer(Value value) {
        super.copyServer(value);
        if (value instanceof ValueBoolean) {
            this.serverValue = ((ValueBoolean)value).value;
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        this.superFromBytes(buffer);
        this.value = buffer.readBoolean();
        this.defaultValue = buffer.readBoolean();
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        this.superToBytes(buffer);
        buffer.writeBoolean(((Boolean)this.value).booleanValue());
        buffer.writeBoolean(((Boolean)this.defaultValue).booleanValue());
    }

    @Override
    public void valueFromBytes(ByteBuf buffer) {
        this.value = buffer.readBoolean();
    }

    @Override
    public void valueToBytes(ByteBuf buffer) {
        buffer.writeBoolean(((Boolean)this.value).booleanValue());
    }

    public String toString() {
        return Boolean.toString((Boolean)this.value);
    }

    @Override
    public ValueBoolean copy() {
        ValueBoolean clone = new ValueBoolean(this.id);
        clone.defaultValue = this.defaultValue;
        clone.value = this.value;
        clone.serverValue = this.serverValue;
        return clone;
    }
}

