/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config.values;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.gui.GuiConfigPanel;
import mchorse.mclib.config.values.GenericNumberValue;
import mchorse.mclib.config.values.IConfigGuiProvider;
import mchorse.mclib.config.values.IServerValue;
import mchorse.mclib.config.values.Value;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ValueDouble
extends GenericNumberValue<Double>
implements IServerValue,
IConfigGuiProvider {
    public ValueDouble(String id) {
        super(id, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public ValueDouble(String id, double defaultValue) {
        super(id, defaultValue, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public ValueDouble(String id, double defaultValue, double min, double max) {
        super(id, defaultValue, min, max);
    }

    @Override
    public void resetServer() {
        this.serverValue = null;
    }

    @Override
    protected Double getNullValue() {
        return 0.0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiElement> getFields(Minecraft mc, GuiConfigPanel gui) {
        GuiElement element = new GuiElement(mc);
        GuiLabel label = Elements.label(IKey.lang(this.getLabelKey()), 0).anchor(0.0f, 0.5f);
        GuiTrackpadElement trackpad = new GuiTrackpadElement(mc, this);
        trackpad.flex().w(90);
        element.flex().row(0).preferred(0).height(20);
        element.add(label, trackpad.removeTooltip());
        return Arrays.asList(element.tooltip(IKey.lang(this.getCommentKey())));
    }

    @Override
    public void valueFromJSON(JsonElement element) {
        this.set(element.getAsDouble());
    }

    @Override
    public boolean parseFromCommand(String value) {
        try {
            this.set(Double.parseDouble(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void copy(Value value) {
        if (value instanceof ValueDouble) {
            this.value = ((ValueDouble)value).value;
        }
    }

    @Override
    public void copyServer(Value value) {
        if (value instanceof ValueDouble) {
            this.serverValue = ((ValueDouble)value).value;
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        this.superFromBytes(buffer);
        this.value = buffer.readDouble();
        this.defaultValue = buffer.readDouble();
        this.min = buffer.readDouble();
        this.max = buffer.readDouble();
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        this.superToBytes(buffer);
        buffer.writeDouble(((Double)this.value).doubleValue());
        buffer.writeDouble(((Double)this.defaultValue).doubleValue());
        buffer.writeDouble(((Double)this.min).doubleValue());
        buffer.writeDouble(((Double)this.max).doubleValue());
    }

    @Override
    public void valueFromBytes(ByteBuf buffer) {
        this.value = buffer.readDouble();
    }

    @Override
    public void valueToBytes(ByteBuf buffer) {
        buffer.writeDouble(((Double)this.value).doubleValue());
    }

    public String toString() {
        return Double.toString((Double)this.value);
    }

    @Override
    public void valueFromNBT(NBTBase tag) {
        if (tag instanceof NBTPrimitive) {
            this.set(((NBTPrimitive)tag).func_150286_g());
        }
    }

    @Override
    public NBTBase valueToNBT() {
        return new NBTTagDouble(((Double)this.value).doubleValue());
    }

    @Override
    public ValueDouble copy() {
        ValueDouble clone = new ValueDouble(this.id, (Double)this.defaultValue, (Double)this.min, (Double)this.max);
        clone.value = this.value;
        return clone;
    }
}

