/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config.values;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mchorse.mclib.config.values.GenericValue;
import mchorse.mclib.config.values.Value;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ValueItemSlots
extends GenericValue<ItemStack[]> {
    private int size;

    public ValueItemSlots(String id, int size) {
        super(id);
        this.size = size;
        this.defaultValue = this.getNullValue();
        this.reset();
    }

    public ValueItemSlots(String id, ItemStack[] defaultValue) {
        super(id);
        this.size = defaultValue.length;
        this.defaultValue = new ItemStack[defaultValue.length];
        for (int i = 0; i < ((ItemStack[])this.defaultValue).length; ++i) {
            ((ItemStack[])this.defaultValue)[i] = defaultValue[i] == null ? this.getNullElementValue() : defaultValue[i].func_77946_l();
        }
        this.reset();
    }

    @Override
    public void set(@Nonnull ItemStack[] value) {
        if (value == null) {
            return;
        }
        for (int i = 0; i < value.length && i < ((ItemStack[])this.value).length; ++i) {
            ((ItemStack[])this.value)[i] = value[i] == null ? this.getNullElementValue() : value[i].func_77946_l();
        }
        this.saveLater();
    }

    public void set(ItemStack itemStack, int index) {
        if (index < ((ItemStack[])this.value).length) {
            ((ItemStack[])this.value)[index] = itemStack == null ? this.getNullElementValue() : itemStack.func_77946_l();
            this.saveLater();
        }
    }

    @Override
    public void reset() {
        this.value = new ItemStack[((ItemStack[])this.defaultValue).length];
        for (int i = 0; i < ((ItemStack[])this.value).length; ++i) {
            this.set(((ItemStack[])this.defaultValue)[i], i);
        }
    }

    @Override
    public ItemStack[] get() {
        ItemStack[] copy = new ItemStack[((ItemStack[])this.value).length];
        for (int i = 0; i < ((ItemStack[])this.value).length; ++i) {
            copy[i] = ((ItemStack[])this.value)[i].func_77946_l();
        }
        return copy;
    }

    public ItemStack get(int index) throws IndexOutOfBoundsException {
        return ((ItemStack[])this.value)[index].func_77946_l();
    }

    public int size() {
        return this.size;
    }

    protected ItemStack getNullElementValue() {
        return ItemStack.field_190927_a;
    }

    @Override
    protected ItemStack[] getNullValue() {
        Object[] nullValue = new ItemStack[this.size];
        Arrays.fill(nullValue, this.getNullElementValue());
        return nullValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ValueItemSlots)) {
            return false;
        }
        ValueItemSlots valueObj = (ValueItemSlots)obj;
        if (((ItemStack[])this.value).length != ((ItemStack[])valueObj.value).length) {
            return false;
        }
        for (int i = 0; i < ((ItemStack[])this.value).length; ++i) {
            if (ItemStack.func_77989_b((ItemStack)((ItemStack[])this.value)[i], (ItemStack)((ItemStack[])this.defaultValue)[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasChanged() {
        for (int i = 0; i < ((ItemStack[])this.value).length; ++i) {
            if (ItemStack.func_77989_b((ItemStack)((ItemStack[])this.value)[i], (ItemStack)((ItemStack[])this.defaultValue)[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public ValueItemSlots copy() {
        ValueItemSlots copy = new ValueItemSlots(this.id, (ItemStack[])this.defaultValue);
        copy.set((ItemStack[])this.value);
        return copy;
    }

    @Override
    public void copy(Value origin) {
        this.superCopy(origin);
        if (origin instanceof ValueItemSlots) {
            ValueItemSlots valueItemSlots = (ValueItemSlots)origin;
            for (int i = 0; i < ((ItemStack[])valueItemSlots.value).length && i < ((ItemStack[])this.value).length; ++i) {
                ((ItemStack[])this.value)[i] = ((ItemStack[])valueItemSlots.value)[i].func_77946_l();
            }
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        int i;
        this.size = buffer.readInt();
        this.value = new ItemStack[this.size];
        this.defaultValue = new ItemStack[this.size];
        for (i = 0; i < ((ItemStack[])this.value).length; ++i) {
            ((ItemStack[])this.value)[i] = buffer.readBoolean() ? ByteBufUtils.readItemStack((ByteBuf)buffer) : this.getNullElementValue();
        }
        for (i = 0; i < ((ItemStack[])this.defaultValue).length; ++i) {
            ((ItemStack[])this.defaultValue)[i] = buffer.readBoolean() ? ByteBufUtils.readItemStack((ByteBuf)buffer) : this.getNullElementValue();
        }
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        int i;
        buffer.writeInt(this.size);
        for (i = 0; i < ((ItemStack[])this.value).length; ++i) {
            buffer.writeBoolean(((ItemStack[])this.value)[i] != null);
            if (((ItemStack[])this.value)[i] == null) continue;
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)((ItemStack[])this.value)[i]);
        }
        for (i = 0; i < ((ItemStack[])this.defaultValue).length; ++i) {
            buffer.writeBoolean(((ItemStack[])this.defaultValue)[i] != null);
            if (((ItemStack[])this.defaultValue)[i] == null) continue;
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)((ItemStack[])this.defaultValue)[i]);
        }
    }

    @Override
    public void valueFromBytes(ByteBuf buffer) {
        this.size = buffer.readInt();
        this.value = new ItemStack[this.size];
        for (int i = 0; i < ((ItemStack[])this.value).length; ++i) {
            ((ItemStack[])this.value)[i] = buffer.readBoolean() ? ByteBufUtils.readItemStack((ByteBuf)buffer) : this.getNullElementValue();
        }
    }

    @Override
    public void valueToBytes(ByteBuf buffer) {
        buffer.writeInt(this.size);
        for (int i = 0; i < ((ItemStack[])this.value).length; ++i) {
            buffer.writeBoolean(((ItemStack[])this.value)[i] != null);
            if (((ItemStack[])this.value)[i] == null) continue;
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)((ItemStack[])this.value)[i]);
        }
    }

    @Override
    public void valueFromJSON(JsonElement element) {
    }

    @Override
    @Nullable
    public JsonElement valueToJSON() {
        return null;
    }

    @Override
    public void valueFromNBT(NBTBase tag) {
        if (tag instanceof NBTTagList) {
            NBTTagList items = (NBTTagList)tag;
            for (int i = 0; i < items.func_74745_c() && i < ((ItemStack[])this.value).length; ++i) {
                ((ItemStack[])this.value)[i] = new ItemStack(items.func_150305_b(i));
            }
        }
    }

    @Override
    public NBTBase valueToNBT() {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < ((ItemStack[])this.value).length; ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            ItemStack stack = ((ItemStack[])this.value)[i];
            if (!stack.func_190926_b()) {
                stack.func_77955_b(tag);
            }
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < ((ItemStack[])this.value).length; ++i) {
            str = str + ((ItemStack[])this.value)[i].toString() + (i + 1 == ((ItemStack[])this.value).length ? "" : ", ");
        }
        return str;
    }
}

