/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config.values;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.gui.GuiConfigPanel;
import mchorse.mclib.config.values.GenericNumberValue;
import mchorse.mclib.config.values.IConfigGuiProvider;
import mchorse.mclib.config.values.IServerValue;
import mchorse.mclib.config.values.Value;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagLong;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ValueLong
extends GenericNumberValue<Long>
implements IServerValue,
IConfigGuiProvider {
    public ValueLong(String id) {
        super(id, 0L, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public ValueLong(String id, long defaultValue) {
        super(id, defaultValue, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public ValueLong(String id, long defaultValue, long min, long max) {
        super(id, defaultValue, min, max);
    }

    @Override
    public void resetServer() {
        this.serverValue = null;
    }

    @Override
    protected Long getNullValue() {
        return 0L;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiElement> getFields(Minecraft mc, GuiConfigPanel gui) {
        GuiElement element = new GuiElement(mc);
        GuiLabel label = Elements.label(IKey.lang(this.getLabelKey()), 0).anchor(0.0f, 0.5f);
        element.flex().row(0).preferred(0).height(20);
        element.add((IGuiElement)label);
        GuiTrackpadElement trackpad = new GuiTrackpadElement(mc, this);
        trackpad.flex().w(90);
        element.add((IGuiElement)trackpad.removeTooltip());
        return Arrays.asList(element.tooltip(IKey.lang(this.getCommentKey())));
    }

    @Override
    public void valueFromJSON(JsonElement element) {
        this.set(element.getAsLong());
    }

    @Override
    public void valueFromNBT(NBTBase tag) {
        if (tag instanceof NBTPrimitive) {
            this.set(((NBTPrimitive)tag).func_150291_c());
        }
    }

    @Override
    public NBTBase valueToNBT() {
        return new NBTTagLong(((Long)this.value).longValue());
    }

    @Override
    public boolean parseFromCommand(String value) {
        try {
            this.set(Long.parseLong(value));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void copy(Value value) {
        if (value instanceof ValueLong) {
            this.value = ((ValueLong)value).value;
        }
    }

    @Override
    public void copyServer(Value value) {
        if (value instanceof ValueLong) {
            this.serverValue = ((ValueLong)value).value;
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        this.superFromBytes(buffer);
        this.value = buffer.readLong();
        this.defaultValue = buffer.readLong();
        this.min = buffer.readLong();
        this.max = buffer.readLong();
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        this.superToBytes(buffer);
        buffer.writeLong(((Long)this.value).longValue());
        buffer.writeLong(((Long)this.defaultValue).longValue());
        buffer.writeLong(((Long)this.min).longValue());
        buffer.writeLong(((Long)this.max).longValue());
    }

    @Override
    public void valueFromBytes(ByteBuf buffer) {
        this.value = buffer.readLong();
    }

    @Override
    public void valueToBytes(ByteBuf buffer) {
        buffer.writeLong(((Long)this.value).longValue());
    }

    @Override
    public ValueLong copy() {
        ValueLong clone = new ValueLong(this.id, (Long)this.defaultValue, (Long)this.min, (Long)this.max);
        clone.value = this.value;
        return clone;
    }

    public String toString() {
        return Long.toString((Long)this.value);
    }
}

