/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config.values;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTexturePicker;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.gui.GuiConfigPanel;
import mchorse.mclib.config.values.GenericValue;
import mchorse.mclib.config.values.IConfigGuiProvider;
import mchorse.mclib.config.values.IServerValue;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.resources.RLUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ValueRL
extends GenericValue<ResourceLocation>
implements IServerValue,
IConfigGuiProvider {
    @SideOnly(value=Side.CLIENT)
    public static GuiTexturePicker picker;
    private boolean useServer;

    public ValueRL(String id) {
        super(id);
    }

    public ValueRL(String id, ResourceLocation defaultValue) {
        super(id);
        this.defaultValue = defaultValue;
    }

    @Override
    public ResourceLocation get() {
        return !this.useServer ? (ResourceLocation)this.value : (ResourceLocation)this.serverValue;
    }

    @Override
    public void set(ResourceLocation value) {
        this.value = value;
        this.saveLater();
    }

    @Override
    public void set(String value) {
        this.set(RLUtils.create(value));
    }

    @Override
    public void resetServer() {
        this.useServer = false;
        this.serverValue = null;
    }

    @Override
    public void reset() {
        this.set(RLUtils.clone((ResourceLocation)this.defaultValue));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiElement> getFields(Minecraft mc, GuiConfigPanel gui) {
        GuiElement element = new GuiElement(mc);
        GuiLabel label = Elements.label(IKey.lang(this.getLabelKey()), 0).anchor(0.0f, 0.5f);
        GuiButtonElement pick = new GuiButtonElement(mc, IKey.lang("mclib.gui.pick_texture"), button -> {
            if (picker == null) {
                picker = new GuiTexturePicker(mc, null);
            }
            ValueRL.picker.callback = this::set;
            picker.fill((ResourceLocation)this.value);
            picker.flex().relative(gui).wh(1.0f, 1.0f);
            picker.resize();
            if (picker.hasParent()) {
                picker.removeFromParent();
            }
            gui.add((IGuiElement)picker);
        });
        pick.flex().w(90);
        element.flex().row(0).preferred(0).height(20);
        element.add(label, pick);
        return Arrays.asList(element.tooltip(IKey.lang(this.getCommentKey())));
    }

    @Override
    public void valueFromJSON(JsonElement element) {
        this.value = RLUtils.create(element);
    }

    @Override
    public JsonElement valueToJSON() {
        return RLUtils.writeJson((ResourceLocation)this.value);
    }

    @Override
    public void valueFromNBT(NBTBase tag) {
        this.set(RLUtils.create(tag));
    }

    @Override
    @Nullable
    public NBTBase valueToNBT() {
        return RLUtils.writeNbt((ResourceLocation)this.value);
    }

    @Override
    public boolean parseFromCommand(String value) {
        this.set(RLUtils.create(value));
        return true;
    }

    @Override
    public void copy(Value value) {
        if (value instanceof ValueRL) {
            this.value = RLUtils.clone((ResourceLocation)((ValueRL)value).value);
        }
    }

    @Override
    public void copyServer(Value value) {
        if (value instanceof ValueRL) {
            this.useServer = true;
            this.serverValue = RLUtils.clone((ResourceLocation)((ValueRL)value).value);
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        this.superFromBytes(buffer);
        this.value = this.readRL(buffer);
        this.defaultValue = this.readRL(buffer);
    }

    private ResourceLocation readRL(ByteBuf buffer) {
        if (buffer.readBoolean()) {
            NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buffer);
            return RLUtils.create(tag.func_74781_a("RL"));
        }
        return null;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        this.superToBytes(buffer);
        this.writeRL(buffer, (ResourceLocation)this.value);
        this.writeRL(buffer, (ResourceLocation)this.defaultValue);
    }

    @Override
    public void valueFromBytes(ByteBuf buffer) {
        this.value = this.readRL(buffer);
    }

    @Override
    public void valueToBytes(ByteBuf buffer) {
        this.writeRL(buffer, (ResourceLocation)this.value);
    }

    private void writeRL(ByteBuf buffer, ResourceLocation rl) {
        buffer.writeBoolean(rl != null);
        if (rl != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("RL", RLUtils.writeNbt(rl));
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)tag);
        }
    }

    public String toString() {
        return this.value == null ? "" : ((ResourceLocation)this.value).toString();
    }

    @Override
    public ValueRL copy() {
        ValueRL clone = new ValueRL(this.id);
        clone.value = RLUtils.clone((ResourceLocation)this.value);
        clone.defaultValue = RLUtils.clone((ResourceLocation)this.defaultValue);
        clone.serverValue = RLUtils.clone((ResourceLocation)this.serverValue);
        clone.useServer = this.useServer;
        return clone;
    }
}

