/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.core.transformers;

import java.util.ListIterator;
import mchorse.mclib.utils.coremod.ClassTransformer;
import mchorse.mclib.utils.coremod.CoreClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class EntityRendererTransformer
extends ClassTransformer {
    @Override
    public void process(String name, ClassNode node) {
        for (MethodNode methodNode : node.methods) {
            if (methodNode.name.equals(this.checkName(methodNode, "a", "(FJ)V", "updateCameraAndRender", "(FJ)V"))) {
                this.processUpdateCameraAndRender(methodNode);
                continue;
            }
            if (!methodNode.name.equals(this.checkName(methodNode, "a", "(IFJ)V", "renderWorldPass", "(IFJ)V"))) continue;
            this.processRenderWorldPass(methodNode);
        }
    }

    public void processRenderWorldPass(MethodNode method) {
        ListIterator iterator = method.instructions.iterator();
        while (iterator.hasNext()) {
            AbstractInsnNode currentNode = (AbstractInsnNode)iterator.next();
            if (!(currentNode instanceof MethodInsnNode)) continue;
            MethodInsnNode mnode = (MethodInsnNode)currentNode;
            if (!mnode.name.equals("a") && !mnode.name.equals("setupCameraTransform") || !mnode.desc.equals("(FI)V")) continue;
            iterator.add(new MethodInsnNode(184, "mchorse/mclib/utils/MatrixUtils", "ASMAfterCamera", "()V", false));
            System.out.println("McLib: successfully patched renderWorldPass!");
            break;
        }
    }

    public void processUpdateCameraAndRender(MethodNode method) {
        ListIterator it = method.instructions.iterator();
        AbstractInsnNode pre = null;
        AbstractInsnNode post = null;
        int i = 0;
        boolean gui = false;
        while (it.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            if (node instanceof MethodInsnNode) {
                String targetPre;
                MethodInsnNode methodNode = (MethodInsnNode)node;
                String desc = methodNode.owner + "/" + methodNode.name + methodNode.desc;
                String targetPost = CoreClassTransformer.obfuscated ? "rl/b()V" : "net/minecraft/profiler/Profiler/endSection()V";
                String string = targetPre = CoreClassTransformer.obfuscated ? "rl/c(Ljava/lang/String;)V" : "net/minecraft/profiler/Profiler/endStartSection(Ljava/lang/String;)V";
                if (desc.equals(targetPost)) {
                    if (++i != 2) continue;
                    post = node.getPrevious().getPrevious().getPrevious();
                    break;
                }
                if (!gui || !desc.equals(targetPre)) continue;
                pre = node;
                continue;
            }
            if (!(node instanceof LdcInsnNode)) continue;
            LdcInsnNode ldc = (LdcInsnNode)node;
            if (!ldc.cst.equals("gui")) continue;
            gui = true;
        }
        if (pre != null && post != null) {
            method.instructions.insert(pre, (AbstractInsnNode)new MethodInsnNode(184, "mchorse/mclib/client/InputRenderer", "preRenderOverlay", "()V", false));
            method.instructions.insertBefore(post, (AbstractInsnNode)new MethodInsnNode(184, "mchorse/mclib/client/InputRenderer", "postRenderOverlay", "()V", false));
            System.out.println("McLib: successfully patched updateCameraAndRender!");
        }
    }
}

