/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.core.transformers;

import java.util.ArrayList;
import mchorse.mclib.utils.coremod.ClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class PacketBufferTransformer
extends ClassTransformer {
    @Override
    public void process(String name, ClassNode node) {
        for (MethodNode method : node.methods) {
            PacketBufferTransformer.replaceConstant(method, node.name, Short.MAX_VALUE);
        }
    }

    public static void replaceConstant(MethodNode method, String className, int constant) {
        ArrayList<AbstractInsnNode> targets = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode node : method.instructions) {
            if (node.getOpcode() != 17 || ((IntInsnNode)node).operand != constant) continue;
            targets.add(node);
        }
        for (AbstractInsnNode target : targets) {
            method.instructions.insert(target, (AbstractInsnNode)new MethodInsnNode(184, "mchorse/mclib/utils/PayloadASM", "getPayloadSize", "()I", false));
            method.instructions.remove(target);
        }
        if (!targets.isEmpty()) {
            System.out.println("McLib: successfully patched " + className + "." + method.name + "!");
        }
    }
}

