/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.math;

import java.util.HashSet;
import java.util.Set;

public enum Operation {
    ADD("+", 1){

        @Override
        public double calculate(double a, double b) {
            return a + b;
        }
    }
    ,
    SUB("-", 1){

        @Override
        public double calculate(double a, double b) {
            return a - b;
        }
    }
    ,
    MUL("*", 2){

        @Override
        public double calculate(double a, double b) {
            return a * b;
        }
    }
    ,
    DIV("/", 2){

        @Override
        public double calculate(double a, double b) {
            return a / (b == 0.0 ? 1.0 : b);
        }
    }
    ,
    MOD("%", 2){

        @Override
        public double calculate(double a, double b) {
            return a % b;
        }
    }
    ,
    POW("^", 3){

        @Override
        public double calculate(double a, double b) {
            return Math.pow(a, b);
        }
    }
    ,
    AND("&&", -3){

        @Override
        public double calculate(double a, double b) {
            return 7.isTrue(a) && 7.isTrue(b) ? 1.0 : 0.0;
        }
    }
    ,
    OR("||", -3){

        @Override
        public double calculate(double a, double b) {
            return 8.isTrue(a) || 8.isTrue(b) ? 1.0 : 0.0;
        }
    }
    ,
    SHIFT_LEFT("<<", 0){

        @Override
        public double calculate(double a, double b) {
            return (int)a << (int)b;
        }
    }
    ,
    SHIFT_RIGHT(">>", 0){

        @Override
        public double calculate(double a, double b) {
            return (int)a >> (int)b;
        }
    }
    ,
    BIT_AND("&", -1){

        @Override
        public double calculate(double a, double b) {
            return (int)a & (int)b;
        }
    }
    ,
    BIT_OR("|", -1){

        @Override
        public double calculate(double a, double b) {
            return (int)a | (int)b;
        }
    }
    ,
    BIT_XOR("^^", -1){

        @Override
        public double calculate(double a, double b) {
            return (int)a ^ (int)b;
        }
    }
    ,
    LESS("<", -2){

        @Override
        public double calculate(double a, double b) {
            return a < b ? 1.0 : 0.0;
        }
    }
    ,
    LESS_THAN("<=", -2){

        @Override
        public double calculate(double a, double b) {
            return a < b || 15.equals(a, b) ? 1.0 : 0.0;
        }
    }
    ,
    GREATER_THAN(">=", -2){

        @Override
        public double calculate(double a, double b) {
            return a > b || 16.equals(a, b) ? 1.0 : 0.0;
        }
    }
    ,
    GREATER(">", -2){

        @Override
        public double calculate(double a, double b) {
            return a > b ? 1.0 : 0.0;
        }
    }
    ,
    EQUALS("==", -2){

        @Override
        public double calculate(double a, double b) {
            return 18.equals(a, b) ? 1.0 : 0.0;
        }
    }
    ,
    NOT_EQUALS("!=", -2){

        @Override
        public double calculate(double a, double b) {
            return !19.equals(a, b) ? 1.0 : 0.0;
        }
    };

    public static final Set<String> OPERATORS;
    public final String sign;
    public final int value;

    public static boolean equals(double a, double b) {
        return Math.abs(a - b) < 1.0E-5;
    }

    public static boolean isTrue(double value) {
        return !Operation.equals(value, 0.0);
    }

    private Operation(String sign, int value) {
        this.sign = sign;
        this.value = value;
    }

    public abstract double calculate(double var1, double var3);

    static {
        OPERATORS = new HashSet<String>();
        for (Operation op : Operation.values()) {
            OPERATORS.add(op.sign);
        }
    }
}

