/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.network;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public abstract class AbstractDispatcher {
    private final SimpleNetworkWrapper dispatcher;
    private byte nextPacketID;

    public AbstractDispatcher(String modID) {
        this.dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel(modID);
    }

    public SimpleNetworkWrapper get() {
        return this.dispatcher;
    }

    public abstract void register();

    public void sendToTracked(Entity entity, IMessage message) {
        EntityTracker tracker = ((WorldServer)entity.field_70170_p).func_73039_n();
        for (EntityPlayer player : tracker.getTrackingPlayers(entity)) {
            this.dispatcher.sendTo(message, (EntityPlayerMP)player);
        }
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.dispatcher.sendTo(message, player);
    }

    public void sendToAll(IMessage message) {
        this.dispatcher.sendToAll(message);
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.dispatcher.sendToAllAround(message, point);
    }

    public void sendToServer(IMessage message) {
        this.dispatcher.sendToServer(message);
    }

    public <REQ extends IMessage, REPLY extends IMessage> void register(Class<REQ> message, Class<? extends IMessageHandler<REQ, REPLY>> handler, Side side) {
        byte by = this.nextPacketID;
        this.nextPacketID = (byte)(by + 1);
        this.dispatcher.registerMessage(handler, message, (int)by, side);
    }
}

