/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils;

import io.netty.buffer.ByteBuf;
import mchorse.mclib.network.IByteBufSerializable;

public class LatencyTimer
implements IByteBufSerializable {
    private long startTime = System.currentTimeMillis();
    private long endTime;

    public void finish() {
        if (this.endTime == 0L) {
            this.endTime = System.currentTimeMillis();
        }
    }

    public long getElapsedTime() {
        return Math.abs(this.endTime != 0L ? this.endTime - this.startTime : System.currentTimeMillis() - this.startTime);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        LatencyTimer timer = new LatencyTimer();
        timer.startTime = buf.readLong();
        timer.endTime = buf.readLong();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.startTime);
        buf.writeLong(this.endTime);
    }
}

