/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils;

import java.nio.FloatBuffer;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MatrixUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RenderingUtils {
    private static final FloatBuffer matrixBuffer = BufferUtils.createFloatBuffer((int)16);

    public static void glRevertRotationScale() {
        matrixBuffer.clear();
        MatrixUtils.matrixToFloatBuffer(matrixBuffer, RenderingUtils.getRevertRotationScale());
        GL11.glMultMatrix((FloatBuffer)matrixBuffer);
    }

    public static Matrix4f getRevertRotationScale() {
        Matrix4d[] transformation = MatrixUtils.getTransformation();
        Matrix4d invertRotScale = new Matrix4d();
        invertRotScale.setIdentity();
        invertRotScale.m00 = transformation[2].m00 != 0.0 ? 1.0 / transformation[2].m00 : 0.0;
        invertRotScale.m11 = transformation[2].m11 != 0.0 ? 1.0 / transformation[2].m11 : 0.0;
        invertRotScale.m22 = transformation[2].m22 != 0.0 ? 1.0 / transformation[2].m22 : 0.0;
        try {
            transformation[1].invert();
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
        invertRotScale.mul(transformation[1], invertRotScale);
        return new Matrix4f(invertRotScale);
    }

    public static void glRevertRotationScale(Vector3d rotation, Vector3d scale, MatrixUtils.RotationOrder rotationOrder) {
        double invSx = scale.x != 0.0 ? 1.0 / scale.x : 0.0;
        double invSy = scale.y != 0.0 ? 1.0 / scale.y : 0.0;
        double invSz = scale.z != 0.0 ? 1.0 / scale.z : 0.0;
        GlStateManager.func_179139_a((double)invSx, (double)invSy, (double)invSz);
        float rotx = (float)(-Math.toDegrees(rotation.x));
        float roty = (float)(-Math.toDegrees(rotation.y));
        float rotz = (float)(-Math.toDegrees(rotation.z));
        switch (rotationOrder) {
            case ZYX: {
                GlStateManager.func_179114_b((float)rotz, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)roty, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)rotx, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case XYZ: {
                GlStateManager.func_179114_b((float)rotx, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)roty, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)rotz, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case XZY: {
                GlStateManager.func_179114_b((float)rotx, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)rotz, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)roty, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case YZX: {
                GlStateManager.func_179114_b((float)roty, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)rotz, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)rotx, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case YXZ: {
                GlStateManager.func_179114_b((float)roty, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)rotx, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)rotz, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case ZXY: {
                GlStateManager.func_179114_b((float)rotz, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)rotx, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)roty, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
    }

    public static Matrix4f getFacingRotation(Facing facing, Vector3f position) {
        boolean lookAt;
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        Matrix4f transform = new Matrix4f();
        Matrix4f rotation = new Matrix4f();
        transform.setIdentity();
        float cYaw = -Interpolations.lerp(camera.field_70126_B, camera.field_70177_z, partialTicks);
        float cPitch = Interpolations.lerp(camera.field_70127_C, camera.field_70125_A, partialTicks);
        double cX = Interpolations.lerp(camera.field_70169_q, camera.field_70165_t, (double)partialTicks);
        double cY = Interpolations.lerp(camera.field_70167_r, camera.field_70163_u, (double)partialTicks) + (double)camera.func_70047_e();
        double cZ = Interpolations.lerp(camera.field_70166_s, camera.field_70161_v, (double)partialTicks);
        boolean bl = lookAt = facing == Facing.LOOKAT_XYZ || facing == Facing.LOOKAT_Y;
        if (lookAt) {
            double dX = cX - (double)position.x;
            double dY = cY - (double)position.y;
            double dZ = cZ - (double)position.z;
            double horizontalDistance = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
            cYaw = 180.0f - (float)(Math.toDegrees(MathHelper.func_181159_b((double)dZ, (double)dX)) - 90.0);
            cPitch = (float)Math.toDegrees(MathHelper.func_181159_b((double)dY, (double)horizontalDistance));
        }
        if (facing == Facing.LOOKAT_XYZ || facing == Facing.ROTATE_XYZ) {
            rotation.rotX((float)Math.toRadians(cPitch));
            transform.mul(rotation);
            rotation.rotY((float)Math.toRadians(180.0f - cYaw));
            transform.mul(rotation);
        } else if (facing == Facing.ROTATE_Y || facing == Facing.LOOKAT_Y) {
            rotation.rotY((float)Math.toRadians(180.0f - cYaw));
            transform.mul(rotation);
        }
        return transform;
    }

    public static void glFacingRotation(Facing facing, Vector3f position) {
        matrixBuffer.clear();
        MatrixUtils.matrixToFloatBuffer(matrixBuffer, RenderingUtils.getFacingRotation(facing, position));
        GL11.glMultMatrix((FloatBuffer)matrixBuffer);
    }

    public static enum Facing {
        ROTATE_XYZ("rotate_xyz"),
        ROTATE_Y("rotate_y"),
        LOOKAT_XYZ("lookat_xyz"),
        LOOKAT_Y("lookat_y");

        public final String id;

        public static Facing fromString(String string) {
            for (Facing facing : Facing.values()) {
                if (!facing.id.equals(string)) continue;
                return facing;
            }
            return null;
        }

        private Facing(String id) {
            this.id = id;
        }
    }
}

