/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import mchorse.mclib.config.values.GenericBaseValue;
import mchorse.mclib.config.values.GenericValue;
import mchorse.mclib.network.IByteBufSerializable;
import mchorse.mclib.network.INBTSerializable;
import net.minecraft.nbt.NBTTagCompound;

public class ValueSerializer
implements IByteBufSerializable,
INBTSerializable {
    private final Map<String, GenericBaseValue<?>> pool = new LinkedHashMap();
    private final Map<String, String> nbtMap = new HashMap<String, String>();
    private final List<String> nbtAlwaysWrite = new ArrayList<String>();
    private final Map<String, String> jsonMap = new HashMap<String, String>();
    private final List<String> jsonAlwaysWrite = new ArrayList<String>();

    public void registerNBTValue(String nbt, GenericBaseValue<?> value) {
        this.registerValue(nbt, "", value, false, false);
    }

    public void registerNBTValue(String nbt, GenericBaseValue<?> value, boolean alwaysWrite) {
        this.registerValue(nbt, "", value, alwaysWrite, false);
    }

    public void registerJSONValue(String json, GenericBaseValue<?> value) {
        this.registerValue("", json, value, false, false);
    }

    public void registerJSONValue(String json, GenericBaseValue<?> value, boolean alwaysWrite) {
        this.registerValue("", json, value, false, alwaysWrite);
    }

    public void registerValue(String nbt, String json, GenericBaseValue<?> value) {
        this.registerValue(nbt, json, value, false, false);
    }

    public void registerValue(String nbt, String json, GenericBaseValue<?> value, boolean alwaysWriteNBT, boolean alwaysWriteJSON) {
        String uuid;
        if (value == null) {
            return;
        }
        if (!nbt.isEmpty() && !this.nbtMap.containsKey(nbt)) {
            uuid = this.poolValue(value);
            this.nbtMap.put(nbt, uuid);
            if (alwaysWriteNBT) {
                this.nbtAlwaysWrite.add(uuid);
            }
        }
        if (!json.isEmpty() && !this.jsonMap.containsKey(json)) {
            uuid = this.poolValue(value);
            this.jsonMap.put(json, uuid);
            if (alwaysWriteJSON) {
                this.jsonAlwaysWrite.add(uuid);
            }
        }
    }

    protected String poolValue(GenericBaseValue<?> value) {
        if (value == null) {
            return null;
        }
        String uuid = this.getValueUUID(value);
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
            this.pool.put(uuid, value);
        }
        return uuid;
    }

    @Nullable
    protected String getValueUUID(GenericBaseValue<?> value) {
        if (value == null) {
            return null;
        }
        for (Map.Entry<String, GenericBaseValue<?>> entry : this.pool.entrySet()) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        for (GenericBaseValue<?> value : this.pool.values()) {
            value.valueFromBytes(buffer);
        }
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        for (GenericBaseValue<?> value : this.pool.values()) {
            value.valueToBytes(buffer);
        }
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        for (Map.Entry<String, String> entry : this.nbtMap.entrySet()) {
            GenericBaseValue<?> value = this.pool.get(entry.getValue());
            String key = entry.getKey();
            if (!tag.func_74764_b(key)) continue;
            value.valueFromNBT(tag.func_74781_a(key));
        }
    }

    @Override
    public NBTTagCompound toNBT(NBTTagCompound tag) {
        for (Map.Entry<String, String> entry : this.nbtMap.entrySet()) {
            GenericBaseValue<?> value = this.pool.get(entry.getValue());
            String uuid = entry.getKey();
            if (!this.nbtAlwaysWrite.contains(uuid) && value instanceof GenericValue && !((GenericValue)value).hasChanged()) continue;
            tag.func_74782_a(uuid, value.valueToNBT());
        }
        return tag;
    }

    public JsonElement toJSON() {
        JsonObject jsonRoot = new JsonObject();
        for (Map.Entry<String, String> entry : this.jsonMap.entrySet()) {
            GenericBaseValue<?> value = this.pool.get(entry.getValue());
            String uuid = entry.getKey();
            if (!this.jsonAlwaysWrite.contains(uuid) && value instanceof GenericValue && !((GenericValue)value).hasChanged()) continue;
            jsonRoot.add(uuid, value.valueToJSON());
        }
        return jsonRoot;
    }

    public void fromJSON(JsonElement element) {
        if (!element.isJsonObject()) {
            return;
        }
        JsonObject jsonObject = element.getAsJsonObject();
        for (Map.Entry<String, String> entry : this.jsonMap.entrySet()) {
            GenericBaseValue<?> value = this.pool.get(entry.getValue());
            String key = entry.getKey();
            if (!jsonObject.has(key)) continue;
            value.valueFromJSON(jsonObject.get(key));
        }
    }
}

