/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils.resources;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.Stack;
import mchorse.mclib.utils.ReflectionUtils;
import mchorse.mclib.utils.resources.MultiResourceLocation;
import mchorse.mclib.utils.resources.TextureProcessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import org.lwjgl.opengl.GL11;

public class MultiskinThread
implements Runnable {
    private static MultiskinThread instance;
    private static Thread thread;
    public Stack<MultiResourceLocation> locations = new Stack();

    public static synchronized void add(MultiResourceLocation location) {
        if (instance != null && !thread.isAlive()) {
            instance = null;
        }
        if (instance == null) {
            instance = new MultiskinThread();
            instance.addLocation(location);
            thread = new Thread(instance);
            thread.start();
        } else {
            instance.addLocation(location);
        }
    }

    public static void clear() {
        instance = null;
    }

    public static ByteBuffer bytesFromBuffer(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        ByteBuffer buffer = GLAllocation.func_74524_c((int)(w * h * 4));
        int[] pixels = new int[w * h];
        image.getRGB(0, 0, w, h, pixels, 0, w);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int pixel = pixels[y * w + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        return buffer;
    }

    public synchronized void addLocation(MultiResourceLocation location) {
        if (this.locations.contains(location)) {
            return;
        }
        this.locations.add(location);
    }

    @Override
    public void run() {
        while (!this.locations.isEmpty() && instance != null) {
            MultiResourceLocation location = this.locations.peek();
            ITextureObject texture = ReflectionUtils.getTextures(Minecraft.func_71410_x().field_71446_o).get(location);
            try {
                if (texture != null) {
                    this.locations.pop();
                    BufferedImage image = TextureProcessor.postProcess(location);
                    int w = image.getWidth();
                    int h = image.getHeight();
                    ByteBuffer buffer = MultiskinThread.bytesFromBuffer(image);
                    Minecraft.func_71410_x().func_152344_a(() -> {
                        TextureUtil.func_110991_a((int)texture.func_110552_b(), (int)w, (int)h);
                        GL11.glBindTexture((int)3553, (int)texture.func_110552_b());
                        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
                        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
                        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)w, (int)h, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
                    });
                }
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        instance = null;
        thread = null;
    }
}

