/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils.shaders;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL20;

public class Shader {
    public int programId = -1;

    public void compile(String vertexPath, String fragmentPath, boolean code) throws Exception {
        if (this.programId != -1) {
            return;
        }
        this.programId = GL20.glCreateProgram();
        int vertex = this.createShader(vertexPath, 35633, code);
        int fragment = this.createShader(fragmentPath, 35632, code);
        GL20.glLinkProgram((int)this.programId);
        if (GL20.glGetProgrami((int)this.programId, (int)35714) == 0) {
            throw new Exception("Error linking Shader code: " + GL20.glGetProgramInfoLog((int)this.programId, (int)1024));
        }
        if (vertex != 0) {
            GL20.glDetachShader((int)this.programId, (int)vertex);
        }
        if (fragment != 0) {
            GL20.glDetachShader((int)this.programId, (int)fragment);
        }
        GL20.glValidateProgram((int)this.programId);
        if (GL20.glGetProgrami((int)this.programId, (int)35715) == 0) {
            System.err.println("Warning validating Shader code: " + GL20.glGetProgramInfoLog((int)this.programId, (int)1024));
        }
        GL20.glDeleteShader((int)vertex);
        GL20.glDeleteShader((int)fragment);
    }

    protected int createShader(String shaderPath, int shaderType, boolean code) throws Exception {
        String shaderCode = code ? shaderPath : IOUtils.toString((InputStream)this.getClass().getResourceAsStream(shaderPath), (Charset)StandardCharsets.UTF_8);
        int shaderId = GL20.glCreateShader((int)shaderType);
        if (shaderId == 0) {
            throw new Exception("Error creating shader. Type: " + shaderType);
        }
        GL20.glShaderSource((int)shaderId, (CharSequence)shaderCode);
        GL20.glCompileShader((int)shaderId);
        if (GL20.glGetShaderi((int)shaderId, (int)35713) == 0) {
            throw new Exception("Error compiling Shader code: " + GL20.glGetShaderInfoLog((int)shaderId, (int)1024));
        }
        GL20.glAttachShader((int)this.programId, (int)shaderId);
        return shaderId;
    }

    public void bind() {
        GL20.glUseProgram((int)this.programId);
    }

    public void unbind() {
        GL20.glUseProgram((int)0);
    }
}

