/*
 * Decompiled with CFR 0.152.
 */
package com.tencao.saomclib;

import com.tencao.saomclib.SAOMCLib;
import com.tencao.saomclib.packets.PacketPipeline;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0006\u001a\u001a\u0010\f\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010\u0012\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a0\u0010\u0013\u001a\u0002H\u0014\"\u000e\b\u0000\u0010\u0014*\b\u0012\u0004\u0012\u0002H\u00140\u0015*\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0017H\u0086\u0002\u00a2\u0006\u0002\u0010\u0018\u001a\u001d\u0010\u0019\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u0014*\b\u0012\u0004\u0012\u0002H\u00140\u001a\u00a2\u0006\u0002\u0010\u001b\u001a\u0012\u0010\u001c\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a#\u0010\u001e\u001a\u00020\u0006*\u00020\u00062\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 \"\u00020!\u00a2\u0006\u0002\u0010\"\u001a+\u0010#\u001a\u00020$*\u00020%2\u0006\u0010&\u001a\u00020\u00062\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 \"\u00020!\u00a2\u0006\u0002\u0010(\u001a\u001b\u0010)\u001a\u00020$*\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020$0,H\u0086\f\u001a\u001b\u0010-\u001a\u00020$*\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020$0,H\u0086\f\u001a\n\u0010.\u001a\u00020\u0006*\u00020/\u001a\n\u00100\u001a\u000201*\u00020/\u001a\u0012\u00102\u001a\u00020$*\u00020\r2\u0006\u00103\u001a\u000204\u001a\n\u00105\u001a\u000206*\u00020\u0006\u001a\u001e\u00107\u001a\u00020\u0006*\u0002062\u0006\u00108\u001a\u00020\u00062\n\b\u0002\u00109\u001a\u0004\u0018\u00010\u0006\u001a\u0012\u0010:\u001a\u00020$*\u00020/2\u0006\u0010&\u001a\u00020\u0006\u001a\u0012\u0010;\u001a\u00020$*\u00020/2\u0006\u0010<\u001a\u000201\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"9\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\b0\u0005*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006="}, d2={"isNotEmpty", "", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)Z", "toolClasses", "", "", "kotlin.jvm.PlatformType", "", "getToolClasses", "(Lnet/minecraft/item/ItemStack;)Ljava/util/Set;", "canLocalize", "checkedPlaceBlock", "Lnet/minecraft/entity/player/EntityPlayerMP;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "checkedReplaceBlock", "get", "T", "", "value", "Lnet/minecraft/block/properties/IProperty;", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/properties/IProperty;)Ljava/lang/Comparable;", "getOrNull", "Ljava/util/Optional;", "(Ljava/util/Optional;)Ljava/lang/Object;", "hasBreakPermission", "hasEditPermission", "localize", "parameters", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "message", "", "Lnet/minecraft/entity/player/EntityPlayer;", "str", "args", "(Lnet/minecraft/entity/player/EntityPlayer;Ljava/lang/String;[Ljava/lang/Object;)V", "onClient", "Lnet/minecraft/world/World;", "body", "Lkotlin/Function0;", "onServer", "readString", "Lio/netty/buffer/ByteBuf;", "readTag", "Lnet/minecraft/nbt/NBTTagCompound;", "sendPacket", "packet", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "toRl", "Lnet/minecraft/util/ResourceLocation;", "translationKey", "type", "suffix", "writeString", "writeTag", "tag", "saomclib"})
public final class HelpersKt {
    public static final void onClient(@NotNull World $this$onClient, @NotNull Function0<Unit> body) {
        int $i$f$onClient = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$onClient, (String)"$this$onClient");
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        if ($this$onClient.field_72995_K) {
            body.invoke();
        }
    }

    public static final void onServer(@NotNull World $this$onServer, @NotNull Function0<Unit> body) {
        int $i$f$onServer = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$onServer, (String)"$this$onServer");
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        if (!$this$onServer.field_72995_K) {
            body.invoke();
        }
    }

    public static final void writeString(@NotNull ByteBuf $this$writeString, @NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)$this$writeString, (String)"$this$writeString");
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        ByteBufUtils.writeUTF8String((ByteBuf)$this$writeString, (String)str);
    }

    @NotNull
    public static final String readString(@NotNull ByteBuf $this$readString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readString, (String)"$this$readString");
        String string = ByteBufUtils.readUTF8String((ByteBuf)$this$readString);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    public static final void writeTag(@NotNull ByteBuf $this$writeTag, @NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)$this$writeTag, (String)"$this$writeTag");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        ByteBufUtils.writeTag((ByteBuf)$this$writeTag, (NBTTagCompound)tag);
    }

    @NotNull
    public static final NBTTagCompound readTag(@NotNull ByteBuf $this$readTag) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readTag, (String)"$this$readTag");
        NBTTagCompound nBTTagCompound = ByteBufUtils.readTag((ByteBuf)$this$readTag);
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"ByteBufUtils.readTag(this)!!");
        return nBTTagCompound;
    }

    public static final void message(@NotNull EntityPlayer $this$message, @NotNull String str, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)$this$message, (String)"$this$message");
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        $this$message.func_145747_a((ITextComponent)new TextComponentTranslation(str, Arrays.copyOf(args, args.length)));
    }

    public static final void sendPacket(@NotNull EntityPlayerMP $this$sendPacket, @NotNull IMessage packet) {
        Intrinsics.checkParameterIsNotNull((Object)$this$sendPacket, (String)"$this$sendPacket");
        Intrinsics.checkParameterIsNotNull((Object)packet, (String)"packet");
        PacketPipeline.INSTANCE.sendTo(packet, $this$sendPacket);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasBreakPermission(@NotNull EntityPlayerMP $this$hasBreakPermission, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hasBreakPermission, (String)"$this$hasBreakPermission");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        if (!HelpersKt.hasEditPermission($this$hasBreakPermission, pos)) return false;
        World world = $this$hasBreakPermission.func_130014_f_();
        PlayerInteractionManager playerInteractionManager = $this$hasBreakPermission.field_71134_c;
        Intrinsics.checkExpressionValueIsNotNull((Object)playerInteractionManager, (String)"this.interactionManager");
        if (ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerInteractionManager.func_73081_b(), (EntityPlayerMP)$this$hasBreakPermission, (BlockPos)pos) == -1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasEditPermission(@NotNull EntityPlayerMP $this$hasEditPermission, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hasEditPermission, (String)"$this$hasEditPermission");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        FMLCommonHandler fMLCommonHandler = FMLCommonHandler.instance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fMLCommonHandler, (String)"FMLCommonHandler.instance()");
        if (fMLCommonHandler.getMinecraftServerInstance().func_175579_a($this$hasEditPermission.func_130014_f_(), pos, (EntityPlayer)$this$hasEditPermission)) return false;
        Intrinsics.checkExpressionValueIsNotNull((Object)EnumFacing.field_82609_l, (String)"EnumFacing.VALUES");
        EnumFacing[] $this$any$iv = EnumFacing.field_82609_l;
        boolean $i$f$any = false;
        EnumFacing[] enumFacingArray = $this$any$iv;
        int n = enumFacingArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumFacing element$iv;
            EnumFacing it = element$iv = enumFacingArray[n2];
            boolean bl = false;
            if ($this$hasEditPermission.func_175151_a(pos, it, ItemStack.field_190927_a)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final boolean checkedPlaceBlock(@NotNull EntityPlayerMP $this$checkedPlaceBlock, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)$this$checkedPlaceBlock, (String)"$this$checkedPlaceBlock");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (!HelpersKt.hasEditPermission($this$checkedPlaceBlock, pos)) {
            return false;
        }
        World world = $this$checkedPlaceBlock.func_130014_f_();
        BlockSnapshot before = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos);
        world.func_175656_a(pos, state);
        Block block = Blocks.field_150350_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"Blocks.AIR");
        BlockEvent.PlaceEvent evt = new BlockEvent.PlaceEvent(before, block.func_176223_P(), (EntityPlayer)$this$checkedPlaceBlock, EnumHand.MAIN_HAND);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (evt.isCanceled()) {
            world.restoringBlockSnapshots = true;
            before.restore(true, false);
            world.restoringBlockSnapshots = false;
            return false;
        }
        return true;
    }

    public static final boolean checkedReplaceBlock(@NotNull EntityPlayerMP $this$checkedReplaceBlock, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)$this$checkedReplaceBlock, (String)"$this$checkedReplaceBlock");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return HelpersKt.hasBreakPermission($this$checkedReplaceBlock, pos) && HelpersKt.checkedPlaceBlock($this$checkedReplaceBlock, pos, state);
    }

    @NotNull
    public static final String translationKey(@NotNull ResourceLocation $this$translationKey, @NotNull String type, @Nullable String suffix) {
        String string;
        StringBuilder stringBuilder;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)$this$translationKey, (String)"$this$translationKey");
                Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
                stringBuilder = new StringBuilder().append(type).append('.').append($this$translationKey.func_110624_b()).append('.').append($this$translationKey.func_110623_a());
                string = suffix;
                if (string == null) break block2;
                String string2 = string;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                String string3 = '.' + it;
                stringBuilder = stringBuilder2;
                string = string3;
                if (string != null) break block3;
            }
            string = "";
        }
        return stringBuilder.append(string).toString();
    }

    public static /* synthetic */ String translationKey$default(ResourceLocation resourceLocation, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return HelpersKt.translationKey(resourceLocation, string, string2);
    }

    @Nullable
    public static final <T> T getOrNull(@NotNull Optional<T> $this$getOrNull) {
        Intrinsics.checkParameterIsNotNull($this$getOrNull, (String)"$this$getOrNull");
        return $this$getOrNull.orElse(null);
    }

    public static final Set<String> getToolClasses(@NotNull ItemStack $this$toolClasses) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toolClasses, (String)"$this$toolClasses");
        return $this$toolClasses.func_77973_b().getToolClasses($this$toolClasses);
    }

    public static final boolean isNotEmpty(@NotNull ItemStack $this$isNotEmpty) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNotEmpty, (String)"$this$isNotEmpty");
        return !$this$isNotEmpty.func_190926_b();
    }

    @NotNull
    public static final <T extends Comparable<? super T>> T get(@NotNull IBlockState $this$get, @NotNull IProperty<T> value) {
        Intrinsics.checkParameterIsNotNull((Object)$this$get, (String)"$this$get");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Comparable comparable = $this$get.func_177229_b(value);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"getValue(value)");
        return (T)comparable;
    }

    @NotNull
    public static final String localize(@NotNull String $this$localize, Object ... parameters) {
        Intrinsics.checkParameterIsNotNull((Object)$this$localize, (String)"$this$localize");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        return SAOMCLib.INSTANCE.getProxy().translate($this$localize, Arrays.copyOf(parameters, parameters.length));
    }

    public static final boolean canLocalize(@NotNull String $this$canLocalize) {
        Intrinsics.checkParameterIsNotNull((Object)$this$canLocalize, (String)"$this$canLocalize");
        return SAOMCLib.INSTANCE.getProxy().canTranslate($this$canLocalize);
    }

    @NotNull
    public static final ResourceLocation toRl(@NotNull String $this$toRl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toRl, (String)"$this$toRl");
        return new ResourceLocation($this$toRl);
    }
}

