/*
 * Decompiled with CFR 0.152.
 */
package com.tencao.saomclib.packets;

import com.tencao.saomclib.except.NoConstructorException;
import com.tencao.saomclib.except.UnknownPacketException;
import com.tencao.saomclib.packets.AbstractClientPacketHandler;
import com.tencao.saomclib.packets.AbstractPacketHandler;
import com.tencao.saomclib.packets.AbstractServerPacketHandler;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\f2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bH\u0002J\r\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J6\u0010\u0013\u001a\u00020\u0011\"\b\b\u0000\u0010\u0014*\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u000b2\u0014\u0010\u0016\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00140\r0\u000bH\u0002J4\u0010\u0017\u001a\u00020\u0011\"\b\b\u0000\u0010\u0014*\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u000b2\u0014\u0010\u0016\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00140\r0\u000bJ\u0016\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\fJ6\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020 J\u001e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020$2\u0006\u0010#\u001a\u00020 J\u0016\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010%\u001a\u00020&J\u0016\u0010'\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010(\u001a\u00020\u0007J\u000e\u0010)\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R8\u0010\b\u001a,\u0012(\u0012&\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u0012\u0014\u0012\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\r0\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/tencao/saomclib/packets/PacketPipeline;", "", "()V", "ntw", "Lnet/minecraftforge/fml/common/network/simpleimpl/SimpleNetworkWrapper;", "kotlin.jvm.PlatformType", "packetId", "", "packetz", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Ljava/lang/Class;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "Lcom/tencao/saomclib/packets/AbstractPacketHandler;", "checkValid", "clazz", "init", "", "init$saomclib", "registerImpl", "REQ", "messageClass", "handlerClass", "registerMessage", "sendTo", "message", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "sendToAll", "sendToAllAround", "dimension", "x", "", "y", "z", "range", "Lnet/minecraft/entity/player/EntityPlayer;", "point", "Lnet/minecraftforge/fml/common/network/NetworkRegistry$TargetPoint;", "sendToDimension", "dimensionId", "sendToServer", "saomclib"})
public final class PacketPipeline {
    private static final ArrayList<Pair<Class<? extends IMessage>, Class<? extends AbstractPacketHandler<? extends IMessage>>>> packetz;
    private static final SimpleNetworkWrapper ntw;
    private static int packetId;
    public static final PacketPipeline INSTANCE;

    public final <REQ extends IMessage> void registerMessage(@NotNull Class<REQ> messageClass, @NotNull Class<? extends AbstractPacketHandler<REQ>> handlerClass) {
        Intrinsics.checkParameterIsNotNull(messageClass, (String)"messageClass");
        Intrinsics.checkParameterIsNotNull(handlerClass, (String)"handlerClass");
        this.checkValid(messageClass);
        packetz.add((Pair<Class<? extends IMessage>, Class<? extends AbstractPacketHandler<? extends IMessage>>>)new Pair(messageClass, handlerClass));
    }

    public final void sendTo(@NotNull IMessage message, @NotNull EntityPlayerMP player) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        if (player.field_71135_a != null) {
            ntw.sendTo(message, player);
        }
    }

    public final void sendToAll(@NotNull IMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        ntw.sendToAll(message);
    }

    public final void sendToAllAround(@NotNull IMessage message, @NotNull NetworkRegistry.TargetPoint point) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        ntw.sendToAllAround(message, point);
    }

    public final void sendToAllAround(@NotNull IMessage message, int dimension, double x, double y, double z, double range) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public final void sendToAllAround(@NotNull IMessage message, @NotNull EntityPlayer player, double range) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        WorldProvider worldProvider = player.field_70170_p.field_73011_w;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"player.world.provider");
        this.sendToAllAround(message, worldProvider.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public final void sendToDimension(@NotNull IMessage message, int dimensionId) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        ntw.sendToDimension(message, dimensionId);
    }

    public final void sendToServer(@NotNull IMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        ntw.sendToServer(message);
    }

    public final void init$saomclib() {
        Iterable $this$forEach$iv = packetz;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Object object = it.getFirst();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<net.minecraftforge.fml.common.network.simpleimpl.IMessage>");
            }
            Object object2 = it.getSecond();
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out com.tencao.saomclib.packets.AbstractPacketHandler<net.minecraftforge.fml.common.network.simpleimpl.IMessage>>");
            }
            INSTANCE.registerImpl((Class)object, (Class)object2);
        }
    }

    private final <REQ extends IMessage> void registerImpl(Class<REQ> messageClass, Class<? extends AbstractPacketHandler<REQ>> handlerClass) {
        int n;
        if (!AbstractServerPacketHandler.class.isAssignableFrom(handlerClass)) {
            n = packetId;
            packetId = n + 1;
            ntw.registerMessage(handlerClass, messageClass, n, Side.CLIENT);
        }
        if (!AbstractClientPacketHandler.class.isAssignableFrom(handlerClass)) {
            n = packetId;
            packetId = n + 1;
            ntw.registerMessage(handlerClass, messageClass, n, Side.SERVER);
        }
    }

    private final IMessage checkValid(Class<? extends IMessage> clazz) {
        IMessage iMessage;
        try {
            IMessage iMessage2 = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (iMessage2 == null) {
                throw (Throwable)new NoConstructorException(clazz);
            }
            iMessage = iMessage2;
        }
        catch (NoSuchMethodException e) {
            throw (Throwable)new NoConstructorException(clazz);
        }
        catch (Exception e) {
            throw (Throwable)new UnknownPacketException(clazz, (Throwable)e);
        }
        return iMessage;
    }

    private PacketPipeline() {
    }

    static {
        PacketPipeline packetPipeline;
        INSTANCE = packetPipeline = new PacketPipeline();
        packetz = new ArrayList();
        ntw = NetworkRegistry.INSTANCE.newSimpleChannel("saomclibchannel");
    }
}

