/*
 * Decompiled with CFR 0.152.
 */
package com.tencao.saomclib.party;

import com.tencao.saomclib.events.PartyEventKt;
import com.tencao.saomclib.party.IParty;
import com.tencao.saomclib.party.PlayerInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/tencao/saomclib/party/PartyManager;", "", "()V", "parties", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/tencao/saomclib/party/IParty;", "getParties", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "addParty", "", "party", "clean", "createParty", "player", "Lcom/tencao/saomclib/party/PlayerInfo;", "getInvitedParties", "", "getInvitedParty", "getOrCreateParty", "getPartyObject", "removeParty", "saomclib"})
public final class PartyManager {
    @NotNull
    private static final CopyOnWriteArrayList<IParty> parties;
    public static final PartyManager INSTANCE;

    @NotNull
    public final CopyOnWriteArrayList<IParty> getParties() {
        return parties;
    }

    public final void addParty(@NotNull IParty party) {
        Intrinsics.checkParameterIsNotNull((Object)party, (String)"party");
        parties.add(party);
    }

    @Nullable
    public final IParty getPartyObject(@NotNull PlayerInfo player) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            Iterable $this$firstOrNull$iv = parties;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IParty it = (IParty)element$iv;
                boolean bl = false;
                if (!it.contains(player)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final IParty createParty(@NotNull PlayerInfo player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        IParty party = PartyEventKt.firePartyCreate(this, player);
        Collection collection = parties;
        boolean bl = false;
        collection.add(party);
        return party;
    }

    @NotNull
    public final IParty getOrCreateParty(@NotNull PlayerInfo player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        IParty iParty = this.getPartyObject(player);
        if (iParty == null) {
            iParty = this.createParty(player);
        }
        return iParty;
    }

    @Nullable
    public final IParty getInvitedParty(@NotNull PlayerInfo player) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            Iterable $this$firstOrNull$iv = parties;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IParty it = (IParty)element$iv;
                boolean bl = false;
                if (!it.isInvited(player)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<IParty> getInvitedParties(@NotNull PlayerInfo player) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Iterable $this$filter$iv = parties;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IParty it = (IParty)element$iv$iv;
            boolean bl = false;
            if (!it.isInvited(player)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final void removeParty(@NotNull IParty party) {
        Intrinsics.checkParameterIsNotNull((Object)party, (String)"party");
        parties.remove(party);
    }

    public final void clean() {
        parties.clear();
    }

    private PartyManager() {
    }

    static {
        PartyManager partyManager;
        INSTANCE = partyManager = new PartyManager();
        parties = new CopyOnWriteArrayList();
    }
}

