/*
 * Decompiled with CFR 0.152.
 */
package com.tencao.saomclib.utils.math;

import com.tencao.saomclib.utils.math.Vec2d;
import com.tencao.saomclib.utils.math.VecHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0086\u0002J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000J\u0006\u0010\u001f\u001a\u00020\u0003J\u0006\u0010 \u001a\u00020\u0018J\u0006\u0010!\u001a\u00020\u001aR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\""}, d2={"Lcom/tencao/saomclib/utils/math/BoundingBox2D;", "", "minX", "", "minY", "maxX", "maxY", "(DDDD)V", "min", "Lcom/tencao/saomclib/utils/math/Vec2d;", "max", "(Lcom/tencao/saomclib/utils/math/Vec2d;Lcom/tencao/saomclib/utils/math/Vec2d;)V", "getMax", "()Lcom/tencao/saomclib/utils/math/Vec2d;", "getMin", "pos", "getPos", "size", "getSize", "contains", "", "other", "height", "heightF", "", "heightI", "", "offset", "scale", "amount", "union", "width", "widthF", "widthI", "saomclib"})
public final class BoundingBox2D {
    @NotNull
    private final Vec2d min;
    @NotNull
    private final Vec2d max;

    @NotNull
    public final BoundingBox2D union(@NotNull BoundingBox2D other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new BoundingBox2D(RangesKt.coerceAtMost((double)this.min.getX(), (double)other.min.getX()), RangesKt.coerceAtMost((double)this.min.getY(), (double)other.min.getY()), RangesKt.coerceAtLeast((double)this.max.getX(), (double)other.max.getX()), RangesKt.coerceAtLeast((double)this.max.getY(), (double)other.max.getY()));
    }

    @NotNull
    public final BoundingBox2D offset(@NotNull Vec2d pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return new BoundingBox2D(this.min.plus(pos), this.max.plus(pos));
    }

    @NotNull
    public final BoundingBox2D scale(double amount) {
        Vec2d vec2d;
        Vec2d this_$iv;
        Vec2d vec2d2 = this.min;
        double amount$iv = amount;
        boolean $i$f$times = false;
        Vec2d vec2d3 = this_$iv.mul(amount$iv);
        this_$iv = this.max;
        amount$iv = amount;
        $i$f$times = false;
        Vec2d vec2d4 = vec2d = this_$iv.mul(amount$iv);
        Vec2d vec2d5 = vec2d3;
        return new BoundingBox2D(vec2d5, vec2d4);
    }

    public final boolean contains(@NotNull Vec2d other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return other.getX() <= this.max.getX() && other.getX() >= this.min.getX() && other.getY() <= this.max.getY() && other.getY() >= this.min.getY();
    }

    public final double height() {
        return this.max.getY() - this.min.getY();
    }

    public final double width() {
        return this.max.getX() - this.min.getX();
    }

    public final float heightF() {
        return this.max.getYf() - this.min.getYf();
    }

    public final float widthF() {
        return this.max.getXf() - this.min.getXf();
    }

    public final int heightI() {
        return this.max.getYi() - this.min.getYi();
    }

    public final int widthI() {
        return this.max.getXi() - this.min.getXi();
    }

    @NotNull
    public final Vec2d getPos() {
        return this.min;
    }

    @NotNull
    public final Vec2d getSize() {
        return this.max.minus(this.min);
    }

    @NotNull
    public final Vec2d getMin() {
        return this.min;
    }

    @NotNull
    public final Vec2d getMax() {
        return this.max;
    }

    public BoundingBox2D(@NotNull Vec2d min, @NotNull Vec2d max) {
        Intrinsics.checkParameterIsNotNull((Object)min, (String)"min");
        Intrinsics.checkParameterIsNotNull((Object)max, (String)"max");
        this.min = min;
        this.max = max;
    }

    public BoundingBox2D(double minX, double minY, double maxX, double maxY) {
        this(VecHelpersKt.vec(minX, minY), VecHelpersKt.vec(maxX, maxY));
    }
}

