/*
 * Decompiled with CFR 0.152.
 */
package com.tencao.saoui.api.elements.animator;

import com.tencao.saomclib.utils.math.CommonUtilMethods;
import com.tencao.saoui.api.elements.animator.AnimatableProperty;
import com.tencao.saoui.api.elements.animator.Animation;
import com.tencao.saoui.api.elements.animator.Animator;
import com.tencao.saoui.api.elements.animator.IAnimatable;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\b\u0011\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010>\u001a\u00020?J\b\u0010@\u001a\u00020AH\u0016J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010B\u001a\u00020\u000fJ\u000e\u0010C\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010E\u001a\u00020\u0015J\u0015\u0010F\u001a\u00020A2\u0006\u0010>\u001a\u00020?H\u0000\u00a2\u0006\u0002\bGJ\u0014\u0010H\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010I\u001a\u00020\nJ\f\u0010J\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u00101\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010E\u001a\u00020\u0015J\u0010\u0010K\u001a\u00020\u00152\u0006\u0010E\u001a\u00020\u0015H\u0004J\u0010\u0010L\u001a\u00020A2\u0006\u0010E\u001a\u00020\u0015H&J\f\u0010:\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\u001c@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001fR*\u0010$\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001c8F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b%\u0010&\u001a\u0004\b$\u0010\u001f\"\u0004\b'\u0010!R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\r\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u001f\"\u0004\b0\u0010!R$\u00101\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0017\"\u0004\b3\u0010\u0019R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u00106\u001a\u0004\b4\u00105R\u001a\u00107\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u001f\"\u0004\b9\u0010!R\u001a\u0010:\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u001f\"\u0004\b<\u0010!\u00a8\u0006M"}, d2={"Lcom/tencao/saoui/api/elements/animator/Animation;", "T", "", "target", "property", "Lcom/tencao/saoui/api/elements/animator/AnimatableProperty;", "(Ljava/lang/Object;Lcom/tencao/saoui/api/elements/animator/AnimatableProperty;)V", "Lcom/tencao/saoui/api/elements/animator/IAnimatable;", "(Ljava/lang/Object;Lcom/tencao/saoui/api/elements/animator/IAnimatable;)V", "<set-?>", "", "_id", "get_id$saoui", "()I", "completion", "Ljava/lang/Runnable;", "getCompletion", "()Ljava/lang/Runnable;", "setCompletion", "(Ljava/lang/Runnable;)V", "duration", "", "getDuration", "()F", "setDuration", "(F)V", "end", "getEnd", "", "finished", "getFinished", "()Z", "setFinished$saoui", "(Z)V", "isInAnimator", "value", "isTimeRelative", "isTimeRelative$annotations", "()V", "setTimeRelative", "getProperty", "()Lcom/tencao/saoui/api/elements/animator/IAnimatable;", "repeatCount", "getRepeatCount", "setRepeatCount", "(I)V", "shouldReverse", "getShouldReverse", "setShouldReverse", "start", "getStart", "setStart", "getTarget", "()Ljava/lang/Object;", "Ljava/lang/Object;", "terminated", "getTerminated", "setTerminated", "useAbsoluteTime", "getUseAbsoluteTime", "setUseAbsoluteTime", "addTo", "animator", "Lcom/tencao/saoui/api/elements/animator/Animator;", "complete", "", "fn", "doesInvolveObject", "obj", "time", "onAddedToAnimator", "onAddedToAnimator$saoui", "repeat", "count", "reverseOnRepeat", "timeFraction", "update", "saoui"})
public abstract class Animation<T> {
    private boolean useAbsoluteTime;
    private float start;
    private float duration;
    private boolean shouldReverse;
    private int repeatCount;
    @NotNull
    private Runnable completion;
    private boolean terminated;
    private boolean finished;
    private int _id;
    private final T target;
    @NotNull
    private final IAnimatable<T> property;

    public final boolean getUseAbsoluteTime() {
        return this.useAbsoluteTime;
    }

    public final void setUseAbsoluteTime(boolean bl) {
        this.useAbsoluteTime = bl;
    }

    @Deprecated(message="Use `useAbsoluteTime`")
    public static /* synthetic */ void isTimeRelative$annotations() {
    }

    public final boolean isTimeRelative() {
        return !this.useAbsoluteTime;
    }

    public final void setTimeRelative(boolean value) {
        this.useAbsoluteTime = !value;
    }

    public final float getStart() {
        return this.start;
    }

    public final void setStart(float value) {
        if (this.isInAnimator()) {
            throw (Throwable)new IllegalStateException("Cannot change the start time of an animation once it has been added to an animator");
        }
        this.start = value;
    }

    public final float getDuration() {
        return this.duration;
    }

    public final void setDuration(float f) {
        this.duration = f;
    }

    public final float getEnd() {
        if (this.repeatCount < 0) {
            return FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
        }
        float duration = this.duration;
        if (this.shouldReverse) {
            duration *= (float)2;
        }
        if (this.repeatCount > 0) {
            duration *= (float)this.repeatCount;
        }
        return this.start + duration;
    }

    public final boolean getShouldReverse() {
        return this.shouldReverse;
    }

    public final void setShouldReverse(boolean bl) {
        this.shouldReverse = bl;
    }

    public final int getRepeatCount() {
        return this.repeatCount;
    }

    public final void setRepeatCount(int n) {
        this.repeatCount = n;
    }

    @NotNull
    public final Runnable getCompletion() {
        return this.completion;
    }

    public final void setCompletion(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"<set-?>");
        this.completion = runnable;
    }

    protected final float timeFraction(float time) {
        if (time < this.start) {
            return 0.0f;
        }
        if (time > this.getEnd()) {
            return this.shouldReverse ? 0.0f : 1.0f;
        }
        if (this.shouldReverse) {
            float f = (time - this.start) / this.duration % (float)2;
            if (f > 1.0f) {
                return CommonUtilMethods.clamp((float)((float)2 - f), (float)0.0f, (float)1.0f);
            }
            return CommonUtilMethods.clamp((float)f, (float)0.0f, (float)1.0f);
        }
        float f = (time - this.start) / this.duration;
        if (this.repeatCount != 0 && this.repeatCount != 1) {
            f %= 1.0f;
        }
        return CommonUtilMethods.clamp((float)f, (float)0.0f, (float)1.0f);
    }

    public final boolean doesInvolveObject(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        if (this.target == obj) {
            return true;
        }
        return this.property.doesInvolve(this.target, obj);
    }

    public final boolean isInAnimator() {
        return this._id != -1;
    }

    public abstract void update(float var1);

    public void complete() {
        this.completion.run();
        this.finished = true;
    }

    public final boolean getTerminated() {
        return this.terminated;
    }

    public final void setTerminated(boolean bl) {
        this.terminated = bl;
    }

    public final boolean getFinished() {
        return this.finished;
    }

    public final void setFinished$saoui(boolean bl) {
        this.finished = bl;
    }

    public final void onAddedToAnimator$saoui(@NotNull Animator animator) {
        Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
        if (this.isTimeRelative()) {
            Animation animation = this;
            animation.setStart(animation.start + animator.getTime());
        }
        Animator animator2 = animator;
        int n = animator2.getNextID$saoui();
        animator2.setNextID$saoui(n + 1);
        this._id = n;
    }

    public final int get_id$saoui() {
        return this._id;
    }

    @NotNull
    public final Animation<T> completion(@NotNull Runnable fn) {
        Intrinsics.checkParameterIsNotNull((Object)fn, (String)"fn");
        this.completion = fn;
        return this;
    }

    @NotNull
    public final Animation<T> start(float time) {
        this.setStart(time);
        return this;
    }

    @NotNull
    public final Animation<T> duration(float time) {
        this.duration = time;
        return this;
    }

    @NotNull
    public final Animation<T> repeat(int count) {
        this.repeatCount = count;
        return this;
    }

    @NotNull
    public final Animation<T> reverseOnRepeat() {
        this.shouldReverse = true;
        return this;
    }

    @NotNull
    public final Animation<T> useAbsoluteTime() {
        this.useAbsoluteTime = true;
        return this;
    }

    @NotNull
    public final Animation<T> addTo(@NotNull Animator animator) {
        Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
        animator.add(this);
        return this;
    }

    public final T getTarget() {
        return this.target;
    }

    @NotNull
    public final IAnimatable<T> getProperty() {
        return this.property;
    }

    public Animation(T target, @NotNull IAnimatable<T> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        this.target = target;
        this.property = property;
        this.completion = completion.1.INSTANCE;
        this._id = -1;
    }

    @PublishedApi
    public Animation(@NotNull Object target, @NotNull AnimatableProperty<Object> property) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        this(target, (IAnimatable)property);
    }
}

